/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.common;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommon;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonDBRef;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeAvro;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeBean;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeMap;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeObjectArray;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonMethodRef;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariantStream;
import com.espertech.esper.common.client.util.AccessorStyle;
import com.espertech.esper.common.client.util.CacheReferenceType;
import com.espertech.esper.common.client.util.ClassForNameProviderDefault;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.client.util.PropertyResolutionStyle;
import com.espertech.esper.common.client.util.ThreadingProfile;
import com.espertech.esper.common.internal.util.DOMElementIterator;
import com.espertech.esper.common.internal.util.DOMUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationCommonParser {
    public static void doConfigure(ConfigurationCommon common, Element commonElement) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(commonElement.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("event-type")) {
                ConfigurationCommonParser.handleEventTypes(common, element);
                continue;
            }
            if (nodeName.equals("auto-import")) {
                ConfigurationCommonParser.handleAutoImports(common, element);
                continue;
            }
            if (nodeName.equals("auto-import-annotations")) {
                ConfigurationCommonParser.handleAutoImportAnnotations(common, element);
                continue;
            }
            if (nodeName.equals("method-reference")) {
                ConfigurationCommonParser.handleMethodReference(common, element);
                continue;
            }
            if (nodeName.equals("database-reference")) {
                ConfigurationCommonParser.handleDatabaseRefs(common, element);
                continue;
            }
            if (nodeName.equals("variable")) {
                ConfigurationCommonParser.handleVariable(common, element);
                continue;
            }
            if (nodeName.equals("variant-stream")) {
                ConfigurationCommonParser.handleVariantStream(common, element);
                continue;
            }
            if (nodeName.equals("event-meta")) {
                ConfigurationCommonParser.handleEventMeta(common, element);
                continue;
            }
            if (nodeName.equals("logging")) {
                ConfigurationCommonParser.handleLogging(common, element);
                continue;
            }
            if (nodeName.equals("time-source")) {
                ConfigurationCommonParser.handleTimeSource(common, element);
                continue;
            }
            if (nodeName.equals("execution")) {
                ConfigurationCommonParser.handleExecution(common, element);
                continue;
            }
            if (!nodeName.equals("event-type-auto-name")) continue;
            ConfigurationCommonParser.handleEventTypeAutoNames(common, element);
        }
    }

    private static void handleEventTypeAutoNames(ConfigurationCommon configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "package-name");
        configuration.addEventTypeAutoName(name);
    }

    private static void handleExecution(ConfigurationCommon common, Element parentElement) {
        String threadingProfileStr = DOMUtil.getOptionalAttribute(parentElement, "threading-profile");
        if (threadingProfileStr != null) {
            ThreadingProfile profile = ThreadingProfile.valueOf(threadingProfileStr.toUpperCase(Locale.ENGLISH));
            common.getExecution().setThreadingProfile(profile);
        }
    }

    private static void handleTimeSource(ConfigurationCommon common, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("time-unit")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for time-unit element");
            }
            try {
                TimeUnit timeUnit = TimeUnit.valueOf(valueText.toUpperCase(Locale.ENGLISH));
                common.getTimeSource().setTimeUnit(timeUnit);
            }
            catch (Throwable t) {
                throw new ConfigurationException("Value attribute for time-unit element invalid: " + t.getMessage(), t);
            }
        }
    }

    private static void handleLogging(ConfigurationCommon common, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Boolean value;
            String valueText;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("query-plan")) {
                valueText = DOMUtil.getRequiredAttribute(subElement, "enabled");
                value = Boolean.parseBoolean(valueText);
                common.getLogging().setEnableQueryPlan(value);
            }
            if (!subElement.getNodeName().equals("jdbc")) continue;
            valueText = DOMUtil.getRequiredAttribute(subElement, "enabled");
            value = Boolean.parseBoolean(valueText);
            common.getLogging().setEnableJDBC(value);
        }
    }

    private static void handleVariantStream(ConfigurationCommon configuration, Element element) {
        ConfigurationCommonVariantStream variantStream = new ConfigurationCommonVariantStream();
        String varianceName = DOMUtil.getRequiredAttribute(element, "name");
        if (element.getAttributes().getNamedItem("type-variance") != null) {
            String typeVar = element.getAttributes().getNamedItem("type-variance").getTextContent();
            try {
                ConfigurationCommonVariantStream.TypeVariance typeVarianceEnum = ConfigurationCommonVariantStream.TypeVariance.valueOf(typeVar.trim().toUpperCase(Locale.ENGLISH));
                variantStream.setTypeVariance(typeVarianceEnum);
            }
            catch (RuntimeException ex) {
                throw new ConfigurationException("Invalid enumeration value for type-variance attribute '" + typeVar + "'");
            }
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("variant-event-type")) continue;
            String name = subElement.getAttributes().getNamedItem("name").getTextContent();
            variantStream.addEventTypeName(name);
        }
        configuration.addVariantStream(varianceName, variantStream);
    }

    private static void handleDatabaseRefs(ConfigurationCommon configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "name");
        ConfigurationCommonDBRef configDBRef = new ConfigurationCommonDBRef();
        configuration.addDatabaseReference(name, configDBRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Enum parsed;
            String value;
            String className;
            Properties properties;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("datasource-connection")) {
                String lookup = DOMUtil.getRequiredAttribute(subElement, "context-lookup-name");
                properties = DOMUtil.getProperties(subElement, "env-property");
                configDBRef.setDataSourceConnection(lookup, properties);
            }
            if (subElement.getNodeName().equals("datasourcefactory-connection")) {
                className = DOMUtil.getRequiredAttribute(subElement, "class-name");
                properties = DOMUtil.getProperties(subElement, "env-property");
                configDBRef.setDataSourceFactory(properties, className);
                continue;
            }
            if (subElement.getNodeName().equals("drivermanager-connection")) {
                className = DOMUtil.getRequiredAttribute(subElement, "class-name");
                String url = DOMUtil.getRequiredAttribute(subElement, "url");
                String userName = DOMUtil.getRequiredAttribute(subElement, "user");
                String password = DOMUtil.getRequiredAttribute(subElement, "password");
                Properties properties2 = DOMUtil.getProperties(subElement, "connection-arg");
                configDBRef.setDriverManagerConnection(className, url, userName, password, properties2);
                continue;
            }
            if (subElement.getNodeName().equals("connection-lifecycle")) {
                value = DOMUtil.getRequiredAttribute(subElement, "value");
                configDBRef.setConnectionLifecycleEnum(ConfigurationCommonDBRef.ConnectionLifecycleEnum.valueOf(value.toUpperCase(Locale.ENGLISH)));
                continue;
            }
            if (subElement.getNodeName().equals("connection-settings")) {
                if (subElement.getAttributes().getNamedItem("auto-commit") != null) {
                    String autoCommit = subElement.getAttributes().getNamedItem("auto-commit").getTextContent();
                    configDBRef.setConnectionAutoCommit(Boolean.parseBoolean(autoCommit));
                }
                if (subElement.getAttributes().getNamedItem("transaction-isolation") != null) {
                    String transactionIsolation = subElement.getAttributes().getNamedItem("transaction-isolation").getTextContent();
                    configDBRef.setConnectionTransactionIsolation(Integer.parseInt(transactionIsolation));
                }
                if (subElement.getAttributes().getNamedItem("catalog") != null) {
                    String catalog = subElement.getAttributes().getNamedItem("catalog").getTextContent();
                    configDBRef.setConnectionCatalog(catalog);
                }
                if (subElement.getAttributes().getNamedItem("read-only") == null) continue;
                String readOnly = subElement.getAttributes().getNamedItem("read-only").getTextContent();
                configDBRef.setConnectionReadOnly(Boolean.parseBoolean(readOnly));
                continue;
            }
            if (subElement.getNodeName().equals("column-change-case")) {
                value = DOMUtil.getRequiredAttribute(subElement, "value");
                parsed = ConfigurationCommonDBRef.ColumnChangeCaseEnum.valueOf(value.toUpperCase(Locale.ENGLISH));
                configDBRef.setColumnChangeCase((ConfigurationCommonDBRef.ColumnChangeCaseEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("metadata-origin")) {
                value = DOMUtil.getRequiredAttribute(subElement, "value");
                parsed = ConfigurationCommonDBRef.MetadataOriginEnum.valueOf(value.toUpperCase(Locale.ENGLISH));
                configDBRef.setMetadataOrigin((ConfigurationCommonDBRef.MetadataOriginEnum)parsed);
                continue;
            }
            if (subElement.getNodeName().equals("sql-types-mapping")) {
                Integer sqlTypeInt;
                String sqlType = DOMUtil.getRequiredAttribute(subElement, "sql-type");
                String javaType = DOMUtil.getRequiredAttribute(subElement, "java-type");
                try {
                    sqlTypeInt = Integer.parseInt(sqlType);
                }
                catch (NumberFormatException ex) {
                    throw new ConfigurationException("Error converting sql type '" + sqlType + "' to integer java.sql.Types constant");
                }
                configDBRef.addSqlTypesBinding((int)sqlTypeInt, javaType);
                continue;
            }
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = DOMUtil.getRequiredAttribute(subElement, "max-age-seconds");
                String purgeInterval = DOMUtil.getRequiredAttribute(subElement, "purge-interval-seconds");
                CacheReferenceType refTypeEnum = CacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = CacheReferenceType.valueOf(refType.toUpperCase(Locale.ENGLISH));
                }
                configDBRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = DOMUtil.getRequiredAttribute(subElement, "size");
            configDBRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handleVariable(ConfigurationCommon configuration, Element element) {
        String variableName = DOMUtil.getRequiredAttribute(element, "name");
        String type = DOMUtil.getRequiredAttribute(element, "type");
        Class<?> variableType = JavaClassHelper.getClassForSimpleName(type, ClassForNameProviderDefault.INSTANCE);
        if (variableType == null) {
            throw new ConfigurationException("Invalid variable type for variable '" + variableName + "', the type is not recognized");
        }
        Node initValueNode = element.getAttributes().getNamedItem("initialization-value");
        String initValue = null;
        if (initValueNode != null) {
            initValue = initValueNode.getTextContent();
        }
        boolean isConstant = false;
        if (DOMUtil.getOptionalAttribute(element, "constant") != null) {
            isConstant = Boolean.parseBoolean(DOMUtil.getOptionalAttribute(element, "constant"));
        }
        configuration.addVariable(variableName, variableType, (Object)initValue, isConstant);
    }

    private static void handleEventTypes(ConfigurationCommon configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String optionalClassName = DOMUtil.getOptionalAttribute(element, "class");
        if (optionalClassName != null) {
            configuration.addEventType(name, optionalClassName);
        }
        ConfigurationCommonParser.handleEventTypeDef(name, optionalClassName, configuration, element);
    }

    private static void handleEventTypeDef(String name, String optionalClassName, ConfigurationCommon configuration, Node parentNode) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(parentNode.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element eventTypeElement = eventTypeNodeIterator.next();
            String nodeName = eventTypeElement.getNodeName();
            if (nodeName.equals("xml-dom")) {
                ConfigurationCommonParser.handleXMLDOM(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("java-util-map")) {
                ConfigurationCommonParser.handleMap(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("objectarray")) {
                ConfigurationCommonParser.handleObjectArray(name, configuration, eventTypeElement);
                continue;
            }
            if (nodeName.equals("legacy-type")) {
                ConfigurationCommonParser.handleLegacy(name, optionalClassName, configuration, eventTypeElement);
                continue;
            }
            if (!nodeName.equals("avro")) continue;
            ConfigurationCommonParser.handleAvro(name, configuration, eventTypeElement);
        }
    }

    private static void handleXMLDOM(String name, ConfigurationCommon configuration, Element xmldomElement) {
        String rootElementName = DOMUtil.getRequiredAttribute(xmldomElement, "root-element-name");
        String rootElementNamespace = DOMUtil.getOptionalAttribute(xmldomElement, "root-element-namespace");
        String schemaResource = DOMUtil.getOptionalAttribute(xmldomElement, "schema-resource");
        String schemaText = DOMUtil.getOptionalAttribute(xmldomElement, "schema-text");
        String defaultNamespace = DOMUtil.getOptionalAttribute(xmldomElement, "default-namespace");
        String resolvePropertiesAbsoluteStr = DOMUtil.getOptionalAttribute(xmldomElement, "xpath-resolve-properties-absolute");
        String propertyExprXPathStr = DOMUtil.getOptionalAttribute(xmldomElement, "xpath-property-expr");
        String eventSenderChecksRootStr = DOMUtil.getOptionalAttribute(xmldomElement, "event-sender-validates-root");
        String xpathFunctionResolverClass = DOMUtil.getOptionalAttribute(xmldomElement, "xpath-function-resolver");
        String xpathVariableResolverClass = DOMUtil.getOptionalAttribute(xmldomElement, "xpath-variable-resolver");
        String autoFragmentStr = DOMUtil.getOptionalAttribute(xmldomElement, "auto-fragment");
        String startTimestampProperty = DOMUtil.getOptionalAttribute(xmldomElement, "start-timestamp-property-name");
        String endTimestampProperty = DOMUtil.getOptionalAttribute(xmldomElement, "end-timestamp-property-name");
        ConfigurationCommonEventTypeXMLDOM xmlDOMEventTypeDesc = new ConfigurationCommonEventTypeXMLDOM();
        xmlDOMEventTypeDesc.setRootElementName(rootElementName);
        xmlDOMEventTypeDesc.setSchemaResource(schemaResource);
        xmlDOMEventTypeDesc.setSchemaText(schemaText);
        xmlDOMEventTypeDesc.setRootElementNamespace(rootElementNamespace);
        xmlDOMEventTypeDesc.setDefaultNamespace(defaultNamespace);
        xmlDOMEventTypeDesc.setXPathFunctionResolver(xpathFunctionResolverClass);
        xmlDOMEventTypeDesc.setXPathVariableResolver(xpathVariableResolverClass);
        xmlDOMEventTypeDesc.setStartTimestampPropertyName(startTimestampProperty);
        xmlDOMEventTypeDesc.setEndTimestampPropertyName(endTimestampProperty);
        if (resolvePropertiesAbsoluteStr != null) {
            xmlDOMEventTypeDesc.setXPathResolvePropertiesAbsolute(Boolean.parseBoolean(resolvePropertiesAbsoluteStr));
        }
        if (propertyExprXPathStr != null) {
            xmlDOMEventTypeDesc.setXPathPropertyExpr(Boolean.parseBoolean(propertyExprXPathStr));
        }
        if (eventSenderChecksRootStr != null) {
            xmlDOMEventTypeDesc.setEventSenderValidatesRoot(Boolean.parseBoolean(eventSenderChecksRootStr));
        }
        if (autoFragmentStr != null) {
            xmlDOMEventTypeDesc.setAutoFragment(Boolean.parseBoolean(autoFragmentStr));
        }
        configuration.addEventType(name, xmlDOMEventTypeDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            QName xpathConstantType;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("namespace-prefix")) {
                String prefix = DOMUtil.getRequiredAttribute(propertyElement, "prefix");
                String namespace = DOMUtil.getRequiredAttribute(propertyElement, "namespace");
                xmlDOMEventTypeDesc.addNamespacePrefix(prefix, namespace);
            }
            if (!propertyElement.getNodeName().equals("xpath-property")) continue;
            String propertyName = DOMUtil.getRequiredAttribute(propertyElement, "property-name");
            String xPath = DOMUtil.getRequiredAttribute(propertyElement, "xpath");
            String propertyType = DOMUtil.getRequiredAttribute(propertyElement, "type");
            if (propertyType.toUpperCase(Locale.ENGLISH).equals("NUMBER")) {
                xpathConstantType = XPathConstants.NUMBER;
            } else if (propertyType.toUpperCase(Locale.ENGLISH).equals("STRING")) {
                xpathConstantType = XPathConstants.STRING;
            } else if (propertyType.toUpperCase(Locale.ENGLISH).equals("BOOLEAN")) {
                xpathConstantType = XPathConstants.BOOLEAN;
            } else if (propertyType.toUpperCase(Locale.ENGLISH).equals("NODE")) {
                xpathConstantType = XPathConstants.NODE;
            } else if (propertyType.toUpperCase(Locale.ENGLISH).equals("NODESET")) {
                xpathConstantType = XPathConstants.NODESET;
            } else {
                throw new IllegalArgumentException("Invalid xpath property type for property '" + propertyName + "' and type '" + propertyType + "'");
            }
            String castToClass = null;
            if (propertyElement.getAttributes().getNamedItem("cast") != null) {
                castToClass = propertyElement.getAttributes().getNamedItem("cast").getTextContent();
            }
            String optionaleventTypeName = null;
            if (propertyElement.getAttributes().getNamedItem("event-type-name") != null) {
                optionaleventTypeName = propertyElement.getAttributes().getNamedItem("event-type-name").getTextContent();
            }
            if (optionaleventTypeName != null) {
                xmlDOMEventTypeDesc.addXPathPropertyFragment(propertyName, xPath, xpathConstantType, optionaleventTypeName);
                continue;
            }
            xmlDOMEventTypeDesc.addXPathProperty(propertyName, xPath, xpathConstantType, castToClass);
        }
    }

    private static void handleAvro(String name, ConfigurationCommon configuration, Element element) {
        String schemaText = DOMUtil.getOptionalAttribute(element, "schema-text");
        ConfigurationCommonEventTypeAvro avroEventTypeDesc = new ConfigurationCommonEventTypeAvro();
        avroEventTypeDesc.setAvroSchemaText(schemaText);
        configuration.addEventTypeAvro(name, avroEventTypeDesc);
        avroEventTypeDesc.setStartTimestampPropertyName(DOMUtil.getOptionalAttribute(element, "start-timestamp-property-name"));
        avroEventTypeDesc.setEndTimestampPropertyName(DOMUtil.getOptionalAttribute(element, "end-timestamp-property-name"));
        String names = DOMUtil.getOptionalAttribute(element, "supertype-names");
        if (names != null) {
            String[] split = names.split(",");
            for (int i = 0; i < split.length; ++i) {
                avroEventTypeDesc.getSuperTypes().add(split[i].trim());
            }
        }
    }

    private static void handleLegacy(String name, String className, ConfigurationCommon configuration, Element xmldomElement) {
        if (className == null) {
            throw new ConfigurationException("Required class name not supplied for legacy type definition");
        }
        String accessorStyle = DOMUtil.getRequiredAttribute(xmldomElement, "accessor-style");
        String propertyResolution = DOMUtil.getRequiredAttribute(xmldomElement, "property-resolution-style");
        String factoryMethod = DOMUtil.getOptionalAttribute(xmldomElement, "factory-method");
        String copyMethod = DOMUtil.getOptionalAttribute(xmldomElement, "copy-method");
        String startTimestampProp = DOMUtil.getOptionalAttribute(xmldomElement, "start-timestamp-property-name");
        String endTimestampProp = DOMUtil.getOptionalAttribute(xmldomElement, "end-timestamp-property-name");
        ConfigurationCommonEventTypeBean legacyDesc = new ConfigurationCommonEventTypeBean();
        if (accessorStyle != null) {
            legacyDesc.setAccessorStyle(AccessorStyle.valueOf(accessorStyle.toUpperCase(Locale.ENGLISH)));
        }
        if (propertyResolution != null) {
            legacyDesc.setPropertyResolutionStyle(PropertyResolutionStyle.valueOf(propertyResolution.toUpperCase(Locale.ENGLISH)));
        }
        legacyDesc.setFactoryMethod(factoryMethod);
        legacyDesc.setCopyMethod(copyMethod);
        legacyDesc.setStartTimestampPropertyName(startTimestampProp);
        legacyDesc.setEndTimestampPropertyName(endTimestampProp);
        configuration.addEventType(name, className, legacyDesc);
        DOMElementIterator propertyNodeIterator = new DOMElementIterator(xmldomElement.getChildNodes());
        while (propertyNodeIterator.hasNext()) {
            String nameProperty;
            Element propertyElement = propertyNodeIterator.next();
            if (propertyElement.getNodeName().equals("method-property")) {
                nameProperty = DOMUtil.getRequiredAttribute(propertyElement, "name");
                String method = DOMUtil.getRequiredAttribute(propertyElement, "accessor-method");
                legacyDesc.addMethodProperty(nameProperty, method);
                continue;
            }
            if (propertyElement.getNodeName().equals("field-property")) {
                nameProperty = DOMUtil.getRequiredAttribute(propertyElement, "name");
                String field = DOMUtil.getRequiredAttribute(propertyElement, "accessor-field");
                legacyDesc.addFieldProperty(nameProperty, field);
                continue;
            }
            throw new ConfigurationException("Invalid node " + propertyElement.getNodeName() + " encountered while parsing legacy type definition");
        }
    }

    private static void handleMap(String name, ConfigurationCommon configuration, Element eventTypeElement) {
        String startTimestampProp = DOMUtil.getOptionalAttribute(eventTypeElement, "start-timestamp-property-name");
        String endTimestampProp = DOMUtil.getOptionalAttribute(eventTypeElement, "end-timestamp-property-name");
        Node superTypesList = eventTypeElement.getAttributes().getNamedItem("supertype-names");
        if (superTypesList != null || startTimestampProp != null || endTimestampProp != null) {
            ConfigurationCommonEventTypeMap config = new ConfigurationCommonEventTypeMap();
            if (superTypesList != null) {
                String[] names;
                String value = superTypesList.getTextContent();
                for (String superTypeName : names = value.split(",")) {
                    config.getSuperTypes().add(superTypeName.trim());
                }
            }
            config.setEndTimestampPropertyName(endTimestampProp);
            config.setStartTimestampPropertyName(startTimestampProp);
            configuration.addMapConfiguration(name, config);
        }
        Properties propertyTypeNames = new Properties();
        NodeList propertyList = eventTypeElement.getElementsByTagName("map-property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String nameProperty = DOMUtil.getRequiredAttribute(propertyList.item(i), "name");
            String clazz = DOMUtil.getRequiredAttribute(propertyList.item(i), "class");
            propertyTypeNames.put(nameProperty, clazz);
        }
        configuration.addEventType(name, propertyTypeNames);
    }

    private static void handleObjectArray(String name, ConfigurationCommon configuration, Element eventTypeElement) {
        String startTimestampProp = DOMUtil.getOptionalAttribute(eventTypeElement, "start-timestamp-property-name");
        String endTimestampProp = DOMUtil.getOptionalAttribute(eventTypeElement, "end-timestamp-property-name");
        Node superTypesList = eventTypeElement.getAttributes().getNamedItem("supertype-names");
        if (superTypesList != null || startTimestampProp != null || endTimestampProp != null) {
            ConfigurationCommonEventTypeObjectArray config = new ConfigurationCommonEventTypeObjectArray();
            if (superTypesList != null) {
                String[] names;
                String value = superTypesList.getTextContent();
                for (String superTypeName : names = value.split(",")) {
                    config.getSuperTypes().add(superTypeName.trim());
                }
            }
            config.setEndTimestampPropertyName(endTimestampProp);
            config.setStartTimestampPropertyName(startTimestampProp);
            configuration.addObjectArrayConfiguration(name, config);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        ArrayList<String> propertyTypes = new ArrayList<String>();
        NodeList propertyList = eventTypeElement.getElementsByTagName("objectarray-property");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            String nameProperty = DOMUtil.getRequiredAttribute(propertyList.item(i), "name");
            String clazz = DOMUtil.getRequiredAttribute(propertyList.item(i), "class");
            propertyNames.add(nameProperty);
            propertyTypes.add(clazz);
        }
        configuration.addEventType(name, propertyNames.toArray(new String[propertyNames.size()]), propertyTypes.toArray());
    }

    private static void handleAutoImports(ConfigurationCommon configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "import-name");
        configuration.addImport(name);
    }

    private static void handleAutoImportAnnotations(ConfigurationCommon configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "import-name");
        configuration.addAnnotationImport(name);
    }

    private static void handleMethodReference(ConfigurationCommon configuration, Element element) {
        String className = DOMUtil.getRequiredAttribute(element, "class-name");
        ConfigurationCommonMethodRef configMethodRef = new ConfigurationCommonMethodRef();
        configuration.addMethodRef(className, configMethodRef);
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("expiry-time-cache")) {
                String maxAge = DOMUtil.getRequiredAttribute(subElement, "max-age-seconds");
                String purgeInterval = DOMUtil.getRequiredAttribute(subElement, "purge-interval-seconds");
                CacheReferenceType refTypeEnum = CacheReferenceType.getDefault();
                if (subElement.getAttributes().getNamedItem("ref-type") != null) {
                    String refType = subElement.getAttributes().getNamedItem("ref-type").getTextContent();
                    refTypeEnum = CacheReferenceType.valueOf(refType.toUpperCase(Locale.ENGLISH));
                }
                configMethodRef.setExpiryTimeCache(Double.parseDouble(maxAge), Double.parseDouble(purgeInterval), refTypeEnum);
                continue;
            }
            if (!subElement.getNodeName().equals("lru-cache")) continue;
            String size = DOMUtil.getRequiredAttribute(subElement, "size");
            configMethodRef.setLRUCache(Integer.parseInt(size));
        }
    }

    private static void handleEventMeta(ConfigurationCommon common, Element parentElement) {
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        DOMUtil.parseOptionalBoolean(parentElement, "enable-xmlxsd", value -> common.getEventMeta().setEnableXMLXSD((boolean)value));
        while (nodeIterator.hasNext()) {
            String objectvalueTypewidenerFactoryClass;
            String enableSchemaDefaultNonNullStr;
            String enableNativeStringStr;
            Node typeNode;
            Enum value2;
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("class-property-resolution")) {
                Node accessorStyleNode;
                Node styleNode = subElement.getAttributes().getNamedItem("style");
                if (styleNode != null) {
                    String styleText = styleNode.getTextContent();
                    value2 = PropertyResolutionStyle.valueOf(styleText.toUpperCase(Locale.ENGLISH));
                    common.getEventMeta().setClassPropertyResolutionStyle((PropertyResolutionStyle)value2);
                }
                if ((accessorStyleNode = subElement.getAttributes().getNamedItem("accessor-style")) != null) {
                    String accessorStyleText = accessorStyleNode.getTextContent();
                    AccessorStyle value3 = AccessorStyle.valueOf(accessorStyleText.toUpperCase(Locale.ENGLISH));
                    common.getEventMeta().setDefaultAccessorStyle(value3);
                }
            }
            if (subElement.getNodeName().equals("event-representation") && (typeNode = subElement.getAttributes().getNamedItem("type")) != null) {
                String typeText = typeNode.getTextContent();
                value2 = EventUnderlyingType.valueOf(typeText.toUpperCase(Locale.ENGLISH));
                common.getEventMeta().setDefaultEventRepresentation((EventUnderlyingType)value2);
            }
            if (!subElement.getNodeName().equals("avro-settings")) continue;
            String enableAvroStr = DOMUtil.getOptionalAttribute(subElement, "enable-avro");
            if (enableAvroStr != null) {
                common.getEventMeta().getAvroSettings().setEnableAvro(Boolean.parseBoolean(enableAvroStr));
            }
            if ((enableNativeStringStr = DOMUtil.getOptionalAttribute(subElement, "enable-native-string")) != null) {
                common.getEventMeta().getAvroSettings().setEnableNativeString(Boolean.parseBoolean(enableNativeStringStr));
            }
            if ((enableSchemaDefaultNonNullStr = DOMUtil.getOptionalAttribute(subElement, "enable-schema-default-nonnull")) != null) {
                common.getEventMeta().getAvroSettings().setEnableSchemaDefaultNonNull(Boolean.parseBoolean(enableSchemaDefaultNonNullStr));
            }
            if ((objectvalueTypewidenerFactoryClass = DOMUtil.getOptionalAttribute(subElement, "objectvalue-typewidener-factory-class")) != null && objectvalueTypewidenerFactoryClass.trim().length() > 0) {
                common.getEventMeta().getAvroSettings().setObjectValueTypeWidenerFactoryClass(objectvalueTypewidenerFactoryClass.trim());
            }
            String typeRepresentationMapperClass = DOMUtil.getOptionalAttribute(subElement, "type-representation-mapper-class");
            common.getEventMeta().getAvroSettings().setTypeRepresentationMapperClass(typeRepresentationMapperClass);
        }
    }
}

