/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.compiler;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompiler;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerByteCode;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExecution;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.client.soda.StreamSelector;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.util.DOMElementIterator;
import com.espertech.esper.common.internal.util.DOMUtil;
import java.io.Serializable;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Consumer;
import org.w3c.dom.Element;

public class ConfigurationCompilerParser {
    public static void doConfigure(ConfigurationCompiler compiler, Element compilerElement) {
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(compilerElement.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("plugin-view")) {
                ConfigurationCompilerParser.handlePlugInView(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-virtualdw")) {
                ConfigurationCompilerParser.handlePlugInVirtualDW(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-aggregation-function")) {
                ConfigurationCompilerParser.handlePlugInAggregation(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-aggregation-multifunction")) {
                ConfigurationCompilerParser.handlePlugInMultiFunctionAggregation(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-singlerow-function")) {
                ConfigurationCompilerParser.handlePlugInSingleRow(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-guard")) {
                ConfigurationCompilerParser.handlePlugInPatternGuard(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-pattern-observer")) {
                ConfigurationCompilerParser.handlePlugInPatternObserver(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-method-datetime")) {
                ConfigurationCompilerParser.handlePlugInDateTimeMethod(compiler, element);
                continue;
            }
            if (nodeName.equals("plugin-method-enum")) {
                ConfigurationCompilerParser.handlePlugInEnumMethod(compiler, element);
                continue;
            }
            if (nodeName.equals("bytecode")) {
                ConfigurationCompilerParser.handleByteCode(compiler, element);
                continue;
            }
            if (nodeName.equals("logging")) {
                ConfigurationCompilerParser.handleLogging(compiler, element);
                continue;
            }
            if (nodeName.equals("stream-selection")) {
                ConfigurationCompilerParser.handleStreamSelection(compiler, element);
                continue;
            }
            if (nodeName.equals("language")) {
                ConfigurationCompilerParser.handleLanguage(compiler, element);
                continue;
            }
            if (nodeName.equals("scripts")) {
                ConfigurationCompilerParser.handleScripts(compiler, element);
                continue;
            }
            if (nodeName.equals("expression")) {
                ConfigurationCompilerParser.handleExpression(compiler, element);
                continue;
            }
            if (nodeName.equals("execution")) {
                ConfigurationCompilerParser.handleExecution(compiler, element);
                continue;
            }
            if (nodeName.equals("view-resources")) {
                ConfigurationCompilerParser.handleViewResources(compiler, element);
                continue;
            }
            if (!nodeName.equals("serde-settings")) continue;
            ConfigurationCompilerParser.handleSerdeSettings(compiler, element);
        }
    }

    private static void handleViewResources(ConfigurationCompiler compiler, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("iterable-unbound")) {
                String valueText = DOMUtil.getRequiredAttribute(subElement, "enabled");
                Boolean value = Boolean.parseBoolean(valueText);
                compiler.getViewResources().setIterableUnbound(value);
            }
            if (!subElement.getNodeName().equals("outputlimitopt")) continue;
            DOMUtil.parseRequiredBoolean(subElement, "enabled", b -> compiler.getViewResources().setOutputLimitOpt((boolean)b));
        }
    }

    private static void handleExecution(ConfigurationCompiler compiler, Element element) {
        String filterServiceMaxFilterWidthStr = DOMUtil.getOptionalAttribute(element, "filter-service-max-filter-width");
        if (filterServiceMaxFilterWidthStr != null) {
            compiler.getExecution().setFilterServiceMaxFilterWidth(Integer.parseInt(filterServiceMaxFilterWidthStr));
        }
        DOMUtil.parseOptionalBoolean(element, "enable-declared-expr-value-cache", b -> compiler.getExecution().setEnabledDeclaredExprValueCache((boolean)b));
        String filterIndexPlanningStr = DOMUtil.getOptionalAttribute(element, "filter-index-planning");
        if (filterIndexPlanningStr != null) {
            compiler.getExecution().setFilterIndexPlanning(ConfigurationCompilerExecution.FilterIndexPlanning.valueOf(filterIndexPlanningStr.toUpperCase(Locale.ENGLISH)));
        }
    }

    private static void handleExpression(ConfigurationCompiler compiler, Element element) {
        String mathContextStr;
        String duckTypingStr;
        String extendedAggregationStr;
        String udfCache;
        String divZero;
        String integerDivision = DOMUtil.getOptionalAttribute(element, "integer-division");
        if (integerDivision != null) {
            boolean isIntegerDivision = Boolean.parseBoolean(integerDivision);
            compiler.getExpression().setIntegerDivision(isIntegerDivision);
        }
        if ((divZero = DOMUtil.getOptionalAttribute(element, "division-by-zero-is-null")) != null) {
            boolean isDivZero = Boolean.parseBoolean(divZero);
            compiler.getExpression().setDivisionByZeroReturnsNull(isDivZero);
        }
        if ((udfCache = DOMUtil.getOptionalAttribute(element, "udf-cache")) != null) {
            boolean isUdfCache = Boolean.parseBoolean(udfCache);
            compiler.getExpression().setUdfCache(isUdfCache);
        }
        if ((extendedAggregationStr = DOMUtil.getOptionalAttribute(element, "extended-agg")) != null) {
            boolean extendedAggregation = Boolean.parseBoolean(extendedAggregationStr);
            compiler.getExpression().setExtendedAggregation(extendedAggregation);
        }
        if ((duckTypingStr = DOMUtil.getOptionalAttribute(element, "ducktyping")) != null) {
            boolean duckTyping = Boolean.parseBoolean(duckTypingStr);
            compiler.getExpression().setDuckTyping(duckTyping);
        }
        if ((mathContextStr = DOMUtil.getOptionalAttribute(element, "math-context")) != null) {
            try {
                MathContext mathContext = new MathContext(mathContextStr);
                compiler.getExpression().setMathContext(mathContext);
            }
            catch (IllegalArgumentException ex) {
                throw new ConfigurationException("Failed to parse '" + mathContextStr + "' as a MathContext");
            }
        }
    }

    private static void handleScripts(ConfigurationCompiler compiler, Element element) {
        String defaultDialect = DOMUtil.getOptionalAttribute(element, "default-dialect");
        if (defaultDialect != null) {
            compiler.getScripts().setDefaultDialect(defaultDialect);
        }
        DOMUtil.parseOptionalBoolean(element, "enabled", b -> compiler.getScripts().setEnabled((boolean)b));
    }

    private static void handleLanguage(ConfigurationCompiler compiler, Element element) {
        DOMUtil.parseOptionalBoolean(element, "sort-using-collator", b -> compiler.getLanguage().setSortUsingCollator((boolean)b));
    }

    private static void handleStreamSelection(ConfigurationCompiler compiler, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            StreamSelector defaultSelector;
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("stream-selector")) continue;
            String valueText = DOMUtil.getRequiredAttribute(subElement, "value");
            if (valueText == null) {
                throw new ConfigurationException("No value attribute supplied for stream-selector element");
            }
            if (valueText.toUpperCase(Locale.ENGLISH).trim().equals("ISTREAM")) {
                defaultSelector = StreamSelector.ISTREAM_ONLY;
            } else if (valueText.toUpperCase(Locale.ENGLISH).trim().equals("RSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ONLY;
            } else if (valueText.toUpperCase(Locale.ENGLISH).trim().equals("IRSTREAM")) {
                defaultSelector = StreamSelector.RSTREAM_ISTREAM_BOTH;
            } else {
                throw new ConfigurationException("Value attribute for stream-selector element invalid, expected one of the following keywords: istream, irstream, rstream");
            }
            compiler.getStreamSelection().setDefaultStreamSelector(defaultSelector);
        }
    }

    private static void handleLogging(ConfigurationCompiler compiler, Element element) {
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (subElement.getNodeName().equals("code")) {
                DOMUtil.parseRequiredBoolean(subElement, "enabled", b -> compiler.getLogging().setEnableCode((boolean)b));
            }
            if (!subElement.getNodeName().equals("filter-plan")) continue;
            DOMUtil.parseRequiredBoolean(subElement, "enabled", b -> compiler.getLogging().setEnableFilterPlan((boolean)b));
        }
    }

    private static void handleByteCode(ConfigurationCompiler compiler, Element element) {
        ConfigurationCompilerByteCode codegen = compiler.getByteCode();
        DOMUtil.parseOptionalBoolean(element, "include-debugsymbols", codegen::setIncludeDebugSymbols);
        DOMUtil.parseOptionalBoolean(element, "include-comments", codegen::setIncludeComments);
        DOMUtil.parseOptionalBoolean(element, "attach-epl", codegen::setAttachEPL);
        DOMUtil.parseOptionalBoolean(element, "attach-module-epl", codegen::setAttachModuleEPL);
        DOMUtil.parseOptionalBoolean(element, "attach-pattern-epl", codegen::setAttachPatternEPL);
        DOMUtil.parseOptionalBoolean(element, "instrumented", codegen::setInstrumented);
        DOMUtil.parseOptionalBoolean(element, "allow-subscriber", codegen::setAllowSubscriber);
        DOMUtil.parseOptionalInteger(element, "threadpool-compiler-num-threads", codegen::setThreadPoolCompilerNumThreads);
        DOMUtil.parseOptionalInteger(element, "threadpool-compiler-capacity", codegen::setThreadPoolCompilerCapacity);
        DOMUtil.parseOptionalInteger(element, "max-methods-per-class", codegen::setMaxMethodsPerClass);
        DOMUtil.parseOptionalBoolean(element, "allow-inlined-class", codegen::setAllowInlinedClass);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-context", codegen::setAccessModifierContext);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-event-type", codegen::setAccessModifierEventType);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-expression", codegen::setAccessModifierExpression);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-named-window", codegen::setAccessModifierNamedWindow);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-script", codegen::setAccessModifierScript);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-table", codegen::setAccessModifierTable);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-variable", codegen::setAccessModifierVariable);
        ConfigurationCompilerParser.parseOptionalAccessMod(element, "access-modifier-inlined-class", codegen::setAccessModifierInlinedClass);
        String busModifierEventType = DOMUtil.getOptionalAttribute(element, "bus-modifier-event-type");
        if (busModifierEventType != null) {
            try {
                codegen.setBusModifierEventType(EventTypeBusModifier.valueOf(busModifierEventType.trim().toUpperCase(Locale.ENGLISH)));
            }
            catch (Throwable t) {
                throw new ConfigurationException(t.getMessage(), t);
            }
        }
    }

    private static void parseOptionalAccessMod(Element element, String name, Consumer<NameAccessModifier> accessModifier) {
        String value = DOMUtil.getOptionalAttribute(element, name);
        if (value != null) {
            try {
                accessModifier.accept(NameAccessModifier.valueOf(value.trim().toUpperCase(Locale.ENGLISH)));
            }
            catch (Throwable t) {
                throw new ConfigurationException(t.getMessage(), t);
            }
        }
    }

    private static void handlePlugInView(ConfigurationCompiler configuration, Element element) {
        String namespace = DOMUtil.getRequiredAttribute(element, "namespace");
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInView(namespace, name, forgeClassName);
    }

    private static void handlePlugInVirtualDW(ConfigurationCompiler configuration, Element element) {
        String namespace = DOMUtil.getRequiredAttribute(element, "namespace");
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        String config = DOMUtil.getOptionalAttribute(element, "config");
        configuration.addPlugInVirtualDataWindow(namespace, name, forgeClassName, (Serializable)((Object)config));
    }

    private static void handlePlugInAggregation(ConfigurationCompiler configuration, Element element) {
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInAggregationFunctionForge(name, forgeClassName);
    }

    private static void handlePlugInDateTimeMethod(ConfigurationCompiler configuration, Element element) {
        String methodName = DOMUtil.getRequiredAttribute(element, "method-name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInDateTimeMethod(methodName, forgeClassName);
    }

    private static void handlePlugInEnumMethod(ConfigurationCompiler configuration, Element element) {
        String methodName = DOMUtil.getRequiredAttribute(element, "method-name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInEnumMethod(methodName, forgeClassName);
    }

    private static void handlePlugInMultiFunctionAggregation(ConfigurationCompiler configuration, Element element) {
        String functionNames = DOMUtil.getRequiredAttribute(element, "function-names");
        String forgeClassName = DOMUtil.getOptionalAttribute(element, "forge-class");
        DOMElementIterator nodeIterator = new DOMElementIterator(element.getChildNodes());
        HashMap<String, String> additionalProps = null;
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("init-arg")) continue;
            String name = DOMUtil.getRequiredAttribute(subElement, "name");
            String value = DOMUtil.getRequiredAttribute(subElement, "value");
            if (additionalProps == null) {
                additionalProps = new HashMap<String, String>();
            }
            additionalProps.put(name, value);
        }
        ConfigurationCompilerPlugInAggregationMultiFunction config = new ConfigurationCompilerPlugInAggregationMultiFunction(functionNames.split(","), forgeClassName);
        config.setAdditionalConfiguredProperties(additionalProps);
        configuration.addPlugInAggregationMultiFunction(config);
    }

    private static void handlePlugInSingleRow(ConfigurationCompiler configuration, Element element) {
        String filterOptimizableStr;
        String name = element.getAttributes().getNamedItem("name").getTextContent();
        String functionClassName = element.getAttributes().getNamedItem("function-class").getTextContent();
        String functionMethodName = element.getAttributes().getNamedItem("function-method").getTextContent();
        ConfigurationCompilerPlugInSingleRowFunction.ValueCache valueCache = ConfigurationCompilerPlugInSingleRowFunction.ValueCache.DISABLED;
        ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable filterOptimizable = ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.ENABLED;
        String valueCacheStr = DOMUtil.getOptionalAttribute(element, "value-cache");
        if (valueCacheStr != null) {
            valueCache = ConfigurationCompilerPlugInSingleRowFunction.ValueCache.valueOf(valueCacheStr.toUpperCase(Locale.ENGLISH));
        }
        if ((filterOptimizableStr = DOMUtil.getOptionalAttribute(element, "filter-optimizable")) != null) {
            filterOptimizable = ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.valueOf(filterOptimizableStr.toUpperCase(Locale.ENGLISH));
        }
        String rethrowExceptionsStr = DOMUtil.getOptionalAttribute(element, "rethrow-exceptions");
        boolean rethrowExceptions = false;
        if (rethrowExceptionsStr != null) {
            rethrowExceptions = Boolean.parseBoolean(rethrowExceptionsStr);
        }
        String eventTypeName = DOMUtil.getOptionalAttribute(element, "event-type-name");
        configuration.addPlugInSingleRowFunction(new ConfigurationCompilerPlugInSingleRowFunction(name, functionClassName, functionMethodName, valueCache, filterOptimizable, rethrowExceptions, eventTypeName));
    }

    private static void handlePlugInPatternGuard(ConfigurationCompiler configuration, Element element) {
        String namespace = DOMUtil.getRequiredAttribute(element, "namespace");
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInPatternGuard(namespace, name, forgeClassName);
    }

    private static void handlePlugInPatternObserver(ConfigurationCompiler configuration, Element element) {
        String namespace = DOMUtil.getRequiredAttribute(element, "namespace");
        String name = DOMUtil.getRequiredAttribute(element, "name");
        String forgeClassName = DOMUtil.getRequiredAttribute(element, "forge-class");
        configuration.addPlugInPatternObserver(namespace, name, forgeClassName);
    }

    private static void handleSerdeSettings(ConfigurationCompiler configuration, Element parentElement) {
        String text = DOMUtil.getOptionalAttribute(parentElement, "enable-serializable");
        if (text != null) {
            configuration.getSerde().setEnableSerializable(Boolean.parseBoolean(text));
        }
        if ((text = DOMUtil.getOptionalAttribute(parentElement, "enable-externalizable")) != null) {
            configuration.getSerde().setEnableExternalizable(Boolean.parseBoolean(text));
        }
        if ((text = DOMUtil.getOptionalAttribute(parentElement, "enable-extended-builtin")) != null) {
            configuration.getSerde().setEnableExtendedBuiltin(Boolean.parseBoolean(text));
        }
        if ((text = DOMUtil.getOptionalAttribute(parentElement, "enable-serialization-fallback")) != null) {
            configuration.getSerde().setEnableSerializationFallback(Boolean.parseBoolean(text));
        }
        DOMElementIterator nodeIterator = new DOMElementIterator(parentElement.getChildNodes());
        while (nodeIterator.hasNext()) {
            Element subElement = nodeIterator.next();
            if (!subElement.getNodeName().equals("serde-provider-factory")) continue;
            text = DOMUtil.getRequiredAttribute(subElement, "class");
            configuration.getSerde().addSerdeProviderFactory(text);
        }
    }
}

