/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.dataflow.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowOperatorParameterProviderContext;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpInitializeContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ClassInstantiationException;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class DataFlowParameterResolution {
    public static Number resolveNumber(String name, ExprEvaluator optionalEvaluator, Number defaultValue, DataFlowOpInitializeContext context) {
        Number resolvedFromProvider = DataFlowParameterResolution.tryParameterProvider(name, context, Number.class);
        if (resolvedFromProvider != null) {
            return resolvedFromProvider;
        }
        if (optionalEvaluator == null) {
            return defaultValue;
        }
        Number value = (Number)optionalEvaluator.evaluate(null, true, context.getAgentInstanceContext());
        if (value == null) {
            throw new EPException("Parameter '" + name + "' is null and is expected to have a value");
        }
        return value;
    }

    public static String resolveStringRequired(String name, ExprEvaluator optionalEvaluator, DataFlowOpInitializeContext context) {
        String resolvedFromProvider = DataFlowParameterResolution.tryParameterProvider(name, context, String.class);
        if (resolvedFromProvider != null) {
            return resolvedFromProvider;
        }
        if (optionalEvaluator == null) {
            throw new EPException("Parameter by name '" + name + "' has no value");
        }
        String value = (String)optionalEvaluator.evaluate(null, true, context.getAgentInstanceContext());
        if (value == null) {
            throw new EPException("Parameter by name '" + name + "' has a null value");
        }
        return value;
    }

    public static String resolveStringOptional(String name, ExprEvaluator optionalEvaluator, DataFlowOpInitializeContext context) {
        String resolvedFromProvider = DataFlowParameterResolution.tryParameterProvider(name, context, String.class);
        if (resolvedFromProvider != null) {
            return resolvedFromProvider;
        }
        if (optionalEvaluator == null) {
            return null;
        }
        return (String)optionalEvaluator.evaluate(null, true, context.getAgentInstanceContext());
    }

    public static <T> T resolveWithDefault(String name, ExprEvaluator optionalEvaluator, T defaultValue, Class<T> clazz, DataFlowOpInitializeContext context) {
        T resolvedFromProvider = DataFlowParameterResolution.tryParameterProvider(name, context, clazz);
        if (resolvedFromProvider != null) {
            return resolvedFromProvider;
        }
        if (optionalEvaluator == null) {
            return defaultValue;
        }
        Object result = optionalEvaluator.evaluate(null, true, context.getAgentInstanceContext());
        if (result == null) {
            return defaultValue;
        }
        if (JavaClassHelper.getBoxedType(clazz) == JavaClassHelper.getBoxedType(result.getClass())) {
            return (T)result;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(result.getClass(), clazz)) {
            return (T)result;
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface(JavaClassHelper.getBoxedType(result.getClass()), Number.class)) {
            EPTypeClass classTypeBoxed = JavaClassHelper.getBoxedType(ClassHelperGenericType.getClassEPType(clazz));
            EPTypeClass resultType = ClassHelperGenericType.getClassEPType(result.getClass());
            return (T)SimpleNumberCoercerFactory.getCoercer(resultType, classTypeBoxed).coerceBoxed((Number)result);
        }
        return (T)result;
    }

    public static <T> T resolveOptionalInstance(String name, Map<String, Object> configuration, Class<T> clazz, DataFlowOpInitializeContext context) {
        Class theClass;
        T resolvedFromProvider = DataFlowParameterResolution.tryParameterProvider(name, context, clazz);
        if (resolvedFromProvider != null) {
            return resolvedFromProvider;
        }
        if (configuration == null) {
            return null;
        }
        String className = (String)configuration.get("class");
        if (className == null) {
            throw new EPException("Failed to find 'class' parameter for parameter '" + name + "'");
        }
        try {
            theClass = context.getAgentInstanceContext().getClasspathImportServiceRuntime().resolveClass(className, false, ClasspathExtensionClassEmpty.INSTANCE);
        }
        catch (ClasspathImportException e) {
            throw new EPException("Failed to find class for parameter '" + name + "': " + e.getMessage(), e);
        }
        try {
            return (T)JavaClassHelper.instantiate(clazz, theClass);
        }
        catch (ClassInstantiationException ex) {
            throw new EPException("Failed to instantiate class for parameter '" + name + "': " + ex.getMessage(), ex);
        }
    }

    public static Map<String, Object> resolveMap(String name, Map<String, Object> evals, DataFlowOpInitializeContext context) {
        if (evals == null) {
            return null;
        }
        if (evals.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : evals.entrySet()) {
            if (entry.getValue() instanceof ExprEvaluator) {
                try {
                    map.put(name, ((ExprEvaluator)entry.getValue()).evaluate(null, true, context.getAgentInstanceContext()));
                    continue;
                }
                catch (Throwable t) {
                    throw new EPException("Failed to evaluate value for parameter '" + name + "' for entry key '" + entry.getKey() + "': " + t.getMessage(), t);
                }
            }
            map.put(name, entry.getValue());
        }
        return map;
    }

    private static <T> T tryParameterProvider(String name, DataFlowOpInitializeContext context, Class<T> clazz) throws EPException {
        if (context.getAdditionalParameters() != null && context.getAdditionalParameters().containsKey(name)) {
            return (T)context.getAdditionalParameters().get(name);
        }
        if (context.getParameterProvider() == null) {
            return null;
        }
        EPDataFlowOperatorParameterProviderContext ctx = new EPDataFlowOperatorParameterProviderContext(context, name);
        Object value = context.getParameterProvider().provide(ctx);
        if (value == null) {
            return null;
        }
        if (JavaClassHelper.isAssignmentCompatible(value.getClass(), clazz)) {
            return (T)value;
        }
        throw new EPException("Parameter provider provided an unexpected object for parameter '" + name + "' of type '" + value.getClass().getName() + "', expected type '" + clazz.getName() + "'");
    }
}

