/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.meta;

import com.espertech.esper.common.client.type.EPTypeClass;

public class EventTypeIdPair {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EventTypeIdPair.class);
    private final long publicId;
    private final long protectedId;
    private final int hash;

    public EventTypeIdPair(long publicId, long protectedId) {
        this.publicId = publicId;
        this.protectedId = protectedId;
        int result = (int)(publicId ^ publicId >>> 32);
        this.hash = 31 * result + (int)(protectedId ^ protectedId >>> 32);
    }

    public long getPublicId() {
        return this.publicId;
    }

    public long getProtectedId() {
        return this.protectedId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventTypeIdPair that = (EventTypeIdPair)o;
        if (this.publicId != that.publicId) {
            return false;
        }
        return this.protectedId == that.protectedId;
    }

    public int hashCode() {
        return this.hash;
    }

    public static EventTypeIdPair unassigned() {
        return new EventTypeIdPair(-1L, -1L);
    }

    public String toString() {
        return "EventTypeIdPair{publicId=" + this.publicId + ", protectedId=" + this.protectedId + ", hash=" + this.hash + "}";
    }
}

