/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ContextDescriptor;
import com.espertech.esper.common.client.soda.ContextDescriptorCondition;
import com.espertech.esper.common.client.soda.ContextDescriptorConditionFilter;
import com.espertech.esper.common.client.soda.ContextDescriptorKeyedSegmentedItem;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class ContextDescriptorKeyedSegmented
implements ContextDescriptor {
    private static final long serialVersionUID = -7627632179534547604L;
    private List<ContextDescriptorKeyedSegmentedItem> items;
    private List<ContextDescriptorConditionFilter> initiationConditions;
    private ContextDescriptorCondition terminationCondition;

    public ContextDescriptorKeyedSegmented() {
        this.items = new ArrayList<ContextDescriptorKeyedSegmentedItem>();
    }

    public ContextDescriptorKeyedSegmented(List<ContextDescriptorKeyedSegmentedItem> items) {
        this.items = items;
    }

    public ContextDescriptorKeyedSegmented(List<ContextDescriptorKeyedSegmentedItem> items, List<ContextDescriptorConditionFilter> initiationConditions, ContextDescriptorCondition terminationCondition) {
        this.items = items;
        this.initiationConditions = initiationConditions;
        this.terminationCondition = terminationCondition;
    }

    public List<ContextDescriptorKeyedSegmentedItem> getItems() {
        return this.items;
    }

    public void setItems(List<ContextDescriptorKeyedSegmentedItem> items) {
        this.items = items;
    }

    @Override
    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        writer.append("partition by ");
        String delimiter = "";
        for (ContextDescriptorKeyedSegmentedItem item : this.items) {
            writer.append(delimiter);
            item.toEPL(writer, formatter);
            delimiter = ", ";
        }
        if (this.initiationConditions != null && !this.initiationConditions.isEmpty()) {
            writer.append(" initiated by ");
            String delimiterInit = "";
            for (ContextDescriptorConditionFilter filter : this.initiationConditions) {
                writer.append(delimiterInit);
                filter.toEPL(writer, formatter);
                delimiterInit = ", ";
            }
        }
        if (this.terminationCondition != null) {
            writer.append(" terminated by ");
            this.terminationCondition.toEPL(writer, formatter);
        }
    }

    public ContextDescriptorCondition getTerminationCondition() {
        return this.terminationCondition;
    }

    public void setTerminationCondition(ContextDescriptorCondition terminationCondition) {
        this.terminationCondition = terminationCondition;
    }

    public List<ContextDescriptorConditionFilter> getInitiationConditions() {
        return this.initiationConditions;
    }

    public void setInitiationConditions(List<ContextDescriptorConditionFilter> initiationConditions) {
        this.initiationConditions = initiationConditions;
    }
}

