/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.CreateIndexColumn;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class CreateIndexClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String indexName;
    private String windowName;
    private List<CreateIndexColumn> columns = new ArrayList<CreateIndexColumn>();
    private boolean unique;

    public CreateIndexClause() {
    }

    public static CreateIndexClause create(String indexName, String windowName, String ... properties) {
        return new CreateIndexClause(indexName, windowName, properties);
    }

    public static CreateIndexClause create(boolean unique, String indexName, String windowName, String ... properties) {
        return new CreateIndexClause(indexName, windowName, properties, unique);
    }

    public CreateIndexClause(String indexName, String windowName, List<CreateIndexColumn> columns) {
        this(indexName, windowName, columns, false);
    }

    public CreateIndexClause(String indexName, String windowName, List<CreateIndexColumn> columns, boolean unique) {
        this.indexName = indexName;
        this.windowName = windowName;
        this.columns = columns;
        this.unique = unique;
    }

    public CreateIndexClause(String indexName, String windowName, String[] properties) {
        this(indexName, windowName, properties, false);
    }

    public CreateIndexClause(String indexName, String windowName, String[] properties, boolean unique) {
        this.indexName = indexName;
        this.windowName = windowName;
        for (String prop : properties) {
            this.columns.add(new CreateIndexColumn(prop));
        }
        this.unique = unique;
    }

    public void toEPL(StringWriter writer) {
        writer.write("create ");
        if (this.unique) {
            writer.write("unique ");
        }
        writer.write("index ");
        writer.write(this.indexName);
        writer.write(" on ");
        writer.write(this.windowName);
        writer.write(40);
        String delimiter = "";
        for (CreateIndexColumn prop : this.columns) {
            writer.write(delimiter);
            prop.toEPL(writer);
            delimiter = ", ";
        }
        writer.write(41);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String windowName) {
        this.windowName = windowName;
    }

    public List<CreateIndexColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<CreateIndexColumn> columns) {
        this.columns = columns;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }
}

