/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.Expression;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class CreateTableColumn
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String columnName;
    private Expression optionalExpression;
    private String optionalTypeName;
    private List<AnnotationPart> annotations;
    private Boolean primaryKey;

    public CreateTableColumn(String columnName, Expression optionalExpression, String optionalTypeName, List<AnnotationPart> annotations, Boolean primaryKey) {
        this.columnName = columnName;
        this.optionalExpression = optionalExpression;
        this.optionalTypeName = optionalTypeName;
        this.annotations = annotations;
        this.primaryKey = primaryKey;
    }

    public CreateTableColumn() {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public List<AnnotationPart> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationPart> annotations) {
        this.annotations = annotations;
    }

    public Expression getOptionalExpression() {
        return this.optionalExpression;
    }

    public void setOptionalExpression(Expression optionalExpression) {
        this.optionalExpression = optionalExpression;
    }

    public String getOptionalTypeName() {
        return this.optionalTypeName;
    }

    public void setOptionalTypeName(String optionalTypeName) {
        this.optionalTypeName = optionalTypeName;
    }

    public Boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void toEPL(StringWriter writer) {
        writer.append(this.columnName);
        writer.append(" ");
        if (this.optionalExpression != null) {
            this.optionalExpression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else {
            writer.append(this.optionalTypeName);
            if (this.primaryKey.booleanValue()) {
                writer.append(" primary key");
            }
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            writer.append(" ");
            String delimiter = "";
            for (AnnotationPart part : this.annotations) {
                if (part.getName() == null) continue;
                writer.append(delimiter);
                delimiter = " ";
                part.toEPL(writer);
            }
        }
    }
}

