/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.DataFlowOperatorInput;
import com.espertech.esper.common.client.soda.DataFlowOperatorOutput;
import com.espertech.esper.common.client.soda.DataFlowOperatorOutputType;
import com.espertech.esper.common.client.soda.DataFlowOperatorParameter;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class DataFlowOperator
implements Serializable {
    private static final long serialVersionUID = 3702665008312151743L;
    private List<AnnotationPart> annotations;
    private String operatorName;
    private List<DataFlowOperatorInput> input;
    private List<DataFlowOperatorOutput> output;
    private List<DataFlowOperatorParameter> parameters;

    public DataFlowOperator(List<AnnotationPart> annotations, String operatorName, List<DataFlowOperatorInput> input, List<DataFlowOperatorOutput> output, List<DataFlowOperatorParameter> parameters) {
        this.annotations = annotations;
        this.operatorName = operatorName;
        this.input = input;
        this.output = output;
        this.parameters = parameters;
    }

    public DataFlowOperator() {
    }

    public List<AnnotationPart> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationPart> annotations) {
        this.annotations = annotations;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public List<DataFlowOperatorInput> getInput() {
        return this.input;
    }

    public void setInput(List<DataFlowOperatorInput> input) {
        this.input = input;
    }

    public List<DataFlowOperatorOutput> getOutput() {
        return this.output;
    }

    public void setOutput(List<DataFlowOperatorOutput> output) {
        this.output = output;
    }

    public List<DataFlowOperatorParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<DataFlowOperatorParameter> parameters) {
        this.parameters = parameters;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        String delimiter;
        writer.write(this.operatorName);
        if (!this.input.isEmpty()) {
            writer.write("(");
            delimiter = "";
            for (DataFlowOperatorInput inputItem : this.input) {
                writer.write(delimiter);
                this.writeInput(inputItem, writer);
                if (inputItem.getOptionalAsName() != null) {
                    writer.write(" as ");
                    writer.write(inputItem.getOptionalAsName());
                }
                delimiter = ", ";
            }
            writer.write(")");
        }
        if (!this.output.isEmpty()) {
            writer.write(" -> ");
            delimiter = "";
            for (DataFlowOperatorOutput outputItem : this.output) {
                writer.write(delimiter);
                writer.write(outputItem.getStreamName());
                this.writeTypes(outputItem.getTypeInfo(), writer);
                delimiter = ", ";
            }
        }
        if (this.parameters.isEmpty()) {
            writer.write(" {}");
            formatter.endDataFlowOperatorDetails(writer);
        } else {
            writer.write(" {");
            formatter.beginDataFlowOperatorDetails(writer);
            delimiter = ",";
            int count = 0;
            for (DataFlowOperatorParameter parameter : this.parameters) {
                parameter.toEpl(writer);
                if (this.parameters.size() > ++count) {
                    writer.write(delimiter);
                }
                formatter.endDataFlowOperatorConfig(writer);
            }
            writer.write("}");
            formatter.endDataFlowOperatorDetails(writer);
        }
    }

    private void writeInput(DataFlowOperatorInput inputItem, StringWriter writer) {
        if (inputItem.getInputStreamNames().size() > 1) {
            String delimiterNames = "";
            writer.write("(");
            for (String name : inputItem.getInputStreamNames()) {
                writer.write(delimiterNames);
                writer.write(name);
                delimiterNames = ", ";
            }
            writer.write(")");
        } else {
            writer.write(inputItem.getInputStreamNames().get(0));
        }
    }

    private void writeTypes(List<DataFlowOperatorOutputType> types, StringWriter writer) {
        if (types == null || types.isEmpty()) {
            return;
        }
        writer.write("<");
        String typeDelimiter = "";
        for (DataFlowOperatorOutputType type : types) {
            writer.write(typeDelimiter);
            this.writeType(type, writer);
            typeDelimiter = ",";
        }
        writer.write(">");
    }

    private void writeType(DataFlowOperatorOutputType type, StringWriter writer) {
        if (type.isWildcard()) {
            writer.append('?');
            return;
        }
        writer.append(type.getTypeOrClassname());
        this.writeTypes(type.getTypeParameters(), writer);
    }
}

