/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import com.espertech.esper.common.client.soda.ContainedEventSelect;
import com.espertech.esper.common.client.soda.EPStatementFormatter;
import com.espertech.esper.common.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.common.client.soda.OnClause;
import com.espertech.esper.common.client.soda.OnInsertSplitStreamItem;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class OnInsertSplitStreamClause
extends OnClause {
    private static final long serialVersionUID = 0L;
    private boolean first;
    private List<OnInsertSplitStreamItem> items = new ArrayList<OnInsertSplitStreamItem>();

    public OnInsertSplitStreamClause() {
    }

    public static OnInsertSplitStreamClause create(boolean isFirst, List<OnInsertSplitStreamItem> items) {
        return new OnInsertSplitStreamClause(isFirst, items);
    }

    public static OnInsertSplitStreamClause create() {
        return new OnInsertSplitStreamClause(true, new ArrayList<OnInsertSplitStreamItem>());
    }

    public OnInsertSplitStreamClause(boolean isFirst, List<OnInsertSplitStreamItem> items) {
        this.first = isFirst;
        this.items = items;
    }

    public void toEPL(StringWriter writer, EPStatementFormatter formatter) {
        for (OnInsertSplitStreamItem item : this.items) {
            item.getInsertInto().toEPL(writer, formatter, true);
            item.getSelectClause().toEPL(writer, formatter, false, false);
            if (item.getPropertySelects() != null) {
                writer.append(" from ");
                ContainedEventSelect.toEPL(writer, formatter, item.getPropertySelects());
                if (item.getPropertySelectsStreamName() != null) {
                    writer.append(" as ");
                    writer.append(item.getPropertySelectsStreamName());
                }
            }
            if (item.getWhereClause() == null) continue;
            writer.append(" where ");
            item.getWhereClause().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
        if (!this.first) {
            writer.append(" output all");
        }
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean getFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public List<OnInsertSplitStreamItem> getItems() {
        return this.items;
    }

    public void setItems(List<OnInsertSplitStreamItem> items) {
        this.items = items;
    }

    public void addItem(OnInsertSplitStreamItem item) {
        this.items.add(item);
    }
}

