/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.soda;

import java.io.Serializable;
import java.io.StringWriter;

public class RowLimitClause
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Integer numRows;
    private Integer optionalOffsetRows;
    private String numRowsVariable;
    private String optionalOffsetRowsVariable;

    public RowLimitClause() {
    }

    public static RowLimitClause create(String numRowsVariable) {
        return new RowLimitClause(null, null, numRowsVariable, null);
    }

    public static RowLimitClause create(String numRowsVariable, String offsetVariable) {
        return new RowLimitClause(null, null, numRowsVariable, offsetVariable);
    }

    public static RowLimitClause create(int numRows) {
        return new RowLimitClause(numRows, null, null, null);
    }

    public static RowLimitClause create(int numRows, int offset) {
        return new RowLimitClause(numRows, offset, null, null);
    }

    public RowLimitClause(Integer numRows, Integer optionalOffsetRows, String numRowsVariable, String optionalOffsetRowsVariable) {
        this.numRows = numRows;
        this.optionalOffsetRows = optionalOffsetRows;
        this.numRowsVariable = numRowsVariable;
        this.optionalOffsetRowsVariable = optionalOffsetRowsVariable;
    }

    public Integer getNumRows() {
        return this.numRows;
    }

    public void setNumRows(Integer numRows) {
        this.numRows = numRows;
    }

    public Integer getOptionalOffsetRows() {
        return this.optionalOffsetRows;
    }

    public void setOptionalOffsetRows(Integer optionalOffsetRows) {
        this.optionalOffsetRows = optionalOffsetRows;
    }

    public String getNumRowsVariable() {
        return this.numRowsVariable;
    }

    public void setNumRowsVariable(String numRowsVariable) {
        this.numRowsVariable = numRowsVariable;
    }

    public String getOptionalOffsetRowsVariable() {
        return this.optionalOffsetRowsVariable;
    }

    public void setOptionalOffsetRowsVariable(String optionalOffsetRowsVariable) {
        this.optionalOffsetRowsVariable = optionalOffsetRowsVariable;
    }

    public void toEPL(StringWriter writer) {
        if (this.numRowsVariable != null) {
            writer.write(this.numRowsVariable);
        } else if (this.numRows != null) {
            writer.write(Integer.toString(this.numRows));
        } else {
            writer.write(Integer.toString(Integer.MAX_VALUE));
        }
        if (this.optionalOffsetRowsVariable != null) {
            writer.write(" offset ");
            writer.write(this.optionalOffsetRowsVariable);
        } else if (this.optionalOffsetRows != null && this.optionalOffsetRows != 0) {
            writer.write(" offset ");
            writer.write(Integer.toString(this.optionalOffsetRows));
        }
    }
}

