/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.type;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import java.io.StringWriter;
import java.util.function.Consumer;

public class EPTypeClass
implements EPType {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EPTypeClass.class);
    private static final long serialVersionUID = 1801760751392971863L;
    protected final Class<?> typeClass;

    public EPTypeClass(Class<?> typeClass) {
        if (typeClass == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        this.typeClass = typeClass;
    }

    public Class<?> getType() {
        return this.typeClass;
    }

    public String toString() {
        return this.toFullName();
    }

    public void traverseClasses(Consumer<Class<?>> classConsumer) {
        classConsumer.accept(this.typeClass);
    }

    public void appendFullName(StringWriter writer) {
        writer.append(ClassHelperPrint.getClassNameFullyQualPretty(this.typeClass));
    }

    public void appendSimpleName(StringWriter writer) {
        writer.append(this.typeClass.getSimpleName());
    }

    public String toFullName() {
        return ClassHelperPrint.getClassNameFullyQualPretty(this.typeClass);
    }

    public String toSimpleName() {
        return this.typeClass.getSimpleName();
    }

    @Override
    public String getTypeName() {
        return this.toFullName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EPTypeClass that = (EPTypeClass)o;
        return this.typeClass.equals(that.typeClass);
    }

    public int hashCode() {
        return this.typeClass.hashCode();
    }
}

