/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.type;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.function.Consumer;

public class EPTypeClassParameterized
extends EPTypeClass {
    public static final EPTypeClass EPTYPE = new EPTypeClass(EPTypeClassParameterized.class);
    private static final long serialVersionUID = 5048002060526813933L;
    private final EPTypeClass[] parameters;

    public EPTypeClassParameterized(Class<?> typeClass, EPTypeClass[] parameters) {
        super(typeClass);
        this.parameters = parameters;
        if (parameters == null || parameters.length == 0) {
            throw new IllegalStateException("No type parameters provided");
        }
        for (EPTypeClass parameter : parameters) {
            if (parameter != null) continue;
            throw new IllegalStateException("One of the type parameters is null");
        }
    }

    public EPTypeClassParameterized(Class<?> typeClass, EPTypeClass parameter) {
        super(typeClass);
        if (parameter == null) {
            throw new IllegalStateException("Null type parameter provided");
        }
        this.parameters = new EPTypeClass[]{parameter};
    }

    public EPTypeClassParameterized(Class<?> typeClass, EPTypeClass parameterOne, EPTypeClass parameterTwo) {
        super(typeClass);
        if (parameterOne == null || parameterTwo == null) {
            throw new IllegalStateException("Null type parameter provided");
        }
        this.parameters = new EPTypeClass[]{parameterOne, parameterTwo};
    }

    public static EPTypeClassParameterized from(Class<?> typeClass, Class<?> parameter) {
        if (typeClass == null) {
            throw new IllegalStateException("Type is null");
        }
        if (parameter == null) {
            throw new IllegalStateException("Type parameter is null");
        }
        return new EPTypeClassParameterized(typeClass, new EPTypeClass[]{EPTypePremade.getOrCreate(parameter)});
    }

    public static EPTypeClassParameterized from(Class<?> typeClass, EPTypeClass parameter) {
        if (typeClass == null) {
            throw new IllegalStateException("Type is null");
        }
        if (parameter == null) {
            throw new IllegalStateException("Type parameter is null");
        }
        return new EPTypeClassParameterized(typeClass, new EPTypeClass[]{parameter});
    }

    public static EPTypeClassParameterized from(Class<?> typeClass, Class<?> first, Class<?> second) {
        if (typeClass == null) {
            throw new IllegalStateException("Type is null");
        }
        if (first == null) {
            throw new IllegalStateException("First type parameter is null");
        }
        if (second == null) {
            throw new IllegalStateException("Second type parameter is null");
        }
        return new EPTypeClassParameterized(typeClass, new EPTypeClass[]{EPTypePremade.getOrCreate(first), EPTypePremade.getOrCreate(second)});
    }

    public EPTypeClass[] getParameters() {
        return this.parameters;
    }

    @Override
    public void traverseClasses(Consumer<Class<?>> classConsumer) {
        classConsumer.accept(this.typeClass);
        for (EPTypeClass parameter : this.parameters) {
            parameter.traverseClasses(classConsumer);
        }
    }

    @Override
    public String toFullName() {
        StringWriter writer = new StringWriter();
        this.appendFullName(writer);
        return writer.toString();
    }

    @Override
    public String toSimpleName() {
        StringWriter writer = new StringWriter();
        this.appendSimpleName(writer);
        return writer.toString();
    }

    @Override
    public void appendFullName(StringWriter writer) {
        this.append(writer, param -> param.appendFullName(writer));
    }

    @Override
    public void appendSimpleName(StringWriter writer) {
        this.append(writer, param -> param.appendSimpleName(writer));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EPTypeClassParameterized that = (EPTypeClassParameterized)o;
        return Arrays.equals(this.parameters, that.parameters);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }

    private void append(StringWriter writer, Consumer<EPTypeClass> paramWriter) {
        Class<?> innerMost = JavaClassHelper.getArrayComponentTypeInnermost(this.typeClass);
        writer.append(ClassHelperPrint.getClassNameFullyQualPretty(innerMost));
        writer.append("<");
        String delimiter = "";
        for (EPTypeClass param : this.parameters) {
            writer.append(delimiter);
            paramWriter.accept(param);
            delimiter = ",";
        }
        writer.append(">");
        ClassHelperPrint.appendDimensions(writer, this.typeClass);
    }
}

