/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.type;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.Pair;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public enum EPTypePremade {
    BOOLEANPRIMITIVE(Boolean.TYPE),
    BYTEPRIMITIVE(Byte.TYPE),
    CHARPRIMITIVE(Character.TYPE),
    SHORTPRIMITIVE(Short.TYPE),
    INTEGERPRIMITIVE(Integer.TYPE),
    LONGPRIMITIVE(Long.TYPE),
    DOUBLEPRIMITIVE(Double.TYPE),
    FLOATPRIMITIVE(Float.TYPE),
    BOOLEANBOXED(Boolean.class),
    BYTEBOXED(Byte.class),
    CHARBOXED(Character.class),
    SHORTBOXED(Short.class),
    INTEGERBOXED(Integer.class),
    LONGBOXED(Long.class),
    DOUBLEBOXED(Double.class),
    FLOATBOXED(Float.class),
    BIGINTEGER(BigInteger.class),
    BIGDECIMAL(BigDecimal.class),
    BIGINTEGERARRAY(BigInteger[].class),
    BIGDECIMALARRAY(BigDecimal[].class),
    BIGINTEGERARRAYARRAY(BigInteger[][].class),
    BIGDECIMALARRAYARRAY(BigDecimal[][].class),
    STRING(String.class),
    NUMBER(Number.class),
    OBJECT(Object.class),
    VOID(Void.TYPE),
    CHARSEQUENCE(CharSequence.class),
    ZONEDDATETIME(ZonedDateTime.class),
    ZONEDDATETIMEARRAY(ZonedDateTime[].class),
    ZONEDDATETIMEARRAYARRAY(ZonedDateTime[][].class),
    LOCALDATETIME(LocalDateTime.class),
    LOCALDATETIMEARRAY(LocalDateTime[].class),
    LOCALDATETIMEARRAYARRAY(LocalDateTime[][].class),
    LOCALDATE(LocalDate.class),
    LOCALDATEARRAY(LocalDate[].class),
    LOCALDATEARRAYARRAY(LocalDate[][].class),
    LOCALTIME(LocalTime.class),
    DATE(java.util.Date.class),
    CALENDAR(Calendar.class),
    DATEARRAY(java.util.Date[].class),
    CALENDARARRAY(Calendar[].class),
    COLLECTION(Collection.class),
    LIST(List.class),
    LISTARRAY(List[].class),
    ARRAYLIST(ArrayList.class),
    LINKEDLIST(LinkedList.class),
    DEQUE(Deque.class),
    ARRAYDEQUE(ArrayDeque.class),
    SET(Set.class),
    HASHSET(HashSet.class),
    ITERATOR(Iterator.class),
    ITERABLE(Iterable.class),
    OBJECTARRAY(Object[].class),
    OBJECTARRAYARRAY(Object[][].class),
    PAIR(Pair.class),
    MAP(Map.class),
    MAPARRAY(Map[].class),
    TREEMAP(TreeMap.class),
    TREESET(TreeSet.class),
    NAVIGABLEMAP(NavigableMap.class),
    HASHMAP(HashMap.class),
    LINKEDHASHMAP(LinkedHashMap.class),
    LINKEDHASHMAPARRAY(LinkedHashMap[].class),
    LINKEDHASHSET(LinkedHashSet.class),
    NODE(Node.class),
    NODELIST(NodeList.class),
    QNAME(QName.class),
    NODEARRAY(Node[].class),
    STRINGARRAY(String[].class),
    STRINGARRAYARRAY(String[][].class),
    BOOLEANBOXEDARRAY(Boolean[].class),
    BOOLEANBOXEDARRAYARRAY(Boolean[][].class),
    BYTEBOXEDARRAY(Byte[].class),
    BYTEBOXEDARRAYARRAY(Byte[][].class),
    CHARBOXEDARRAY(Character[].class),
    CHARBOXEDARRAYARRAY(Character[][].class),
    SHORTBOXEDARRAY(Short[].class),
    SHORTBOXEDARRAYARRAY(Short[][].class),
    INTEGERBOXEDARRAY(Integer[].class),
    INTEGERBOXEDARRAYARRAY(Integer[][].class),
    LONGBOXEDARRAY(Long[].class),
    LONGBOXEDARRAYARRAY(Long[][].class),
    DOUBLEBOXEDARRAY(Double[].class),
    DOUBLEBOXEDARRAYARRAY(Double[][].class),
    FLOATBOXEDARRAY(Float[].class),
    FLOATBOXEDARRAYARRAY(Float[][].class),
    BOOLEANPRIMITIVEARRAY(boolean[].class),
    BOOLEANPRIMITIVEARRAYARRAY(boolean[][].class),
    BYTEPRIMITIVEARRAY(byte[].class),
    BYTEPRIMITIVEARRAYARRAY(byte[][].class),
    CHARPRIMITIVEARRAY(char[].class),
    CHARPRIMITIVEARRAYARRAY(char[][].class),
    SHORTPRIMITIVEARRAY(short[].class),
    SHORTPRIMITIVEARRAYARRAY(short[][].class),
    INTEGERPRIMITIVEARRAY(int[].class),
    INTEGERPRIMITIVEARRAYARRAY(int[][].class),
    LONGPRIMITIVEARRAY(long[].class),
    LONGPRIMITIVEARRAYARRAY(long[][].class),
    DOUBLEPRIMITIVEARRAY(double[].class),
    DOUBLEPRIMITIVEARRAYARRAY(double[][].class),
    FLOATPRIMITIVEARRAY(float[].class),
    FLOATPRIMITIVEARRAYARRAY(float[][].class),
    COPYONWRITEARRAYLIST(CopyOnWriteArrayList.class),
    COPYONWRITEARRAYSET(CopyOnWriteArraySet.class),
    COMPARATOR(Comparator.class),
    COMPARABLE(Comparable.class),
    SIMPLEDATEFORMAT(SimpleDateFormat.class),
    DATETIMEFORMATTER(DateTimeFormatter.class),
    DATEFORMAT(DateFormat.class),
    INSTRUMENTATION(Instrumentation.class),
    PATTERN(Pattern.class),
    CLASS(Class.class),
    METHOD(Method.class),
    FIELD(Field.class),
    TIMEZONE(TimeZone.class),
    ATOMICLONG(AtomicLong.class),
    MATHCONTEXT(MathContext.class),
    ANNOTATION(Annotation.class),
    ANNOTATIONARRAY(Annotation[].class),
    DATAOUTPUT(DataOutput.class),
    DATAINPUT(DataInput.class),
    BYTEBUFFER(ByteBuffer.class),
    MAPENTRY(Map.Entry.class),
    ABSTRACTMAPSIMPLEENTRY(AbstractMap.SimpleEntry.class),
    STRINGBUFFER(StringBuffer.class),
    STRINGBUILDER(StringBuilder.class),
    UNSUPPORTEDOPERATIONEXCEPTION(UnsupportedOperationException.class),
    ILLEGALSTATEEXCEPTION(IllegalStateException.class),
    NOSUCHELEMENTEXCEPTION(NoSuchElementException.class),
    IOEXCEPTION(IOException.class),
    THROWABLE(Throwable.class),
    SUPPLIER(Supplier.class),
    SQLDATE(Date.class),
    SQLDATEARRAY(Date[].class),
    SQLTIME(Time.class),
    SQLCLOB(Clob.class),
    SQLBLOB(Blob.class),
    SQLARRAY(Array.class),
    SQLSTRUCT(Struct.class),
    SQLREF(Ref.class),
    SQLTIMESTAMP(Timestamp.class),
    NETURL(URL.class),
    NETURLARRAY(URL[].class),
    NETURLARRAYARRAY(URL[][].class),
    NETURI(URI.class),
    NETURIARRAY(URI[].class),
    NETURIARRAYARRAY(URI[][].class),
    UUID(UUID.class),
    UUIDARRAY(UUID[].class),
    UUIDARRAYARRAY(UUID[][].class),
    OFFSETDATETIME(OffsetDateTime.class),
    OFFSETDATETIMEARRAY(OffsetDateTime[].class),
    OFFSETDATETIMEARRAYARRAY(OffsetDateTime[][].class);

    private static Map<Class, EPTypePremade> classToPremade;
    private final EPTypeClass epType;

    private EPTypePremade(Class<?> clazz) {
        this.epType = new EPTypeClass(clazz);
    }

    public static EPTypeClass getOrCreate(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Not available for null clazz");
        }
        EPTypePremade found = classToPremade.get(clazz);
        if (found != null) {
            return found.getEPType();
        }
        return new EPTypeClass(clazz);
    }

    public static EPTypePremade getExisting(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Not available for null clazz");
        }
        return classToPremade.get(clazz);
    }

    public EPTypeClass getEPType() {
        return this.epType;
    }

    static {
        classToPremade = new HashMap<Class, EPTypePremade>();
        for (EPTypePremade premade : EPTypePremade.values()) {
            if (classToPremade.containsKey(premade.epType.typeClass)) {
                throw new IllegalStateException("Class '" + premade.epType.typeClass + "' already among premades");
            }
            classToPremade.put(premade.getEPType().getType(), premade);
        }
    }
}

