/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.MultiKey;
import java.io.Serializable;
import java.util.Arrays;

public final class HashableMultiKey
implements Serializable,
MultiKey {
    public static final EPTypeClass EPTYPE = new EPTypeClass(HashableMultiKey.class);
    private static final long serialVersionUID = -7019971786796246533L;
    private final Object[] keys;

    public HashableMultiKey(Object[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = keys;
    }

    public HashableMultiKey(Object key) {
        this(new Object[]{key});
    }

    public HashableMultiKey(Object key1, Object key2) {
        this(new Object[]{key1, key2});
    }

    public HashableMultiKey(Object key1, Object key2, Object key3) {
        this(new Object[]{key1, key2, key3});
    }

    public HashableMultiKey(Object key1, Object key2, Object key3, Object key4) {
        this(new Object[]{key1, key2, key3, key4});
    }

    public final int size() {
        return this.keys.length;
    }

    public final Object get(int index) {
        return this.keys[index];
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof HashableMultiKey) {
            HashableMultiKey otherKeys = (HashableMultiKey)other;
            return Arrays.equals(this.keys, otherKeys.keys);
        }
        return false;
    }

    @Override
    public int getNumKeys() {
        return this.size();
    }

    @Override
    public Object getKey(int num) {
        if (num >= this.keys.length) {
            throw new IllegalArgumentException("Key number " + num + " larger than number of keys (" + this.size() + ")");
        }
        return this.keys[num];
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public final int hashCode() {
        int total = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            total *= 31;
            total ^= this.keys[i].hashCode();
        }
        return total;
    }

    public final String toString() {
        return "HashableMultiKey" + Arrays.asList(this.keys).toString();
    }
}

