/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.util;

public enum NameAccessModifier {
    TRANSIENT(false, true),
    PRIVATE(true, true),
    PROTECTED(true, false),
    PUBLIC(true, false),
    PRECONFIGURED(false, false);

    private final boolean isAccessModifier;
    private final boolean privateOrTransient;

    private NameAccessModifier(boolean isAccessModifier, boolean privateOrTransient) {
        this.isAccessModifier = isAccessModifier;
        this.privateOrTransient = privateOrTransient;
    }

    public static boolean visible(NameAccessModifier objectVisibility, String objectModuleName, String importModuleName) {
        if (objectVisibility.isPrivateOrTransient()) {
            return false;
        }
        if (objectVisibility == PROTECTED) {
            return NameAccessModifier.compareModuleName(objectModuleName, importModuleName);
        }
        return true;
    }

    public boolean isModuleProvidedAccessModifier() {
        return this.isAccessModifier;
    }

    public boolean isNonPrivateNonTransient() {
        return !this.privateOrTransient && this != PRECONFIGURED;
    }

    public boolean isPrivateOrTransient() {
        return this.privateOrTransient;
    }

    private static boolean compareModuleName(String objectModuleName, String importModuleName) {
        if (objectModuleName == null && importModuleName == null) {
            return true;
        }
        if (objectModuleName != null && importModuleName != null) {
            return objectModuleName.equals(importModuleName);
        }
        return false;
    }
}

