/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.Serializable;

public class TimePeriod
implements Serializable {
    public static final EPTypeClass EPTYPE = new EPTypeClass(TimePeriod.class);
    private static final long serialVersionUID = 1897460581178729620L;
    private Integer years;
    private Integer months;
    private Integer weeks;
    private Integer days;
    private Integer hours;
    private Integer minutes;
    private Integer seconds;
    private Integer milliseconds;
    private Integer microseconds;

    public TimePeriod(Integer years, Integer months, Integer weeks, Integer days, Integer hours, Integer minutes, Integer seconds, Integer milliseconds, Integer microseconds) {
        this.years = years;
        this.months = months;
        this.weeks = weeks;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        this.microseconds = microseconds;
    }

    public TimePeriod() {
    }

    public Integer getYears() {
        return this.years;
    }

    public Integer getMonths() {
        return this.months;
    }

    public Integer getWeeks() {
        return this.weeks;
    }

    public Integer getDays() {
        return this.days;
    }

    public Integer getHours() {
        return this.hours;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public Integer getSeconds() {
        return this.seconds;
    }

    public Integer getMilliseconds() {
        return this.milliseconds;
    }

    public Integer getMicroseconds() {
        return this.microseconds;
    }

    public void setYears(Integer years) {
        this.years = years;
    }

    public void setMonths(Integer months) {
        this.months = months;
    }

    public void setWeeks(Integer weeks) {
        this.weeks = weeks;
    }

    public void setDays(Integer days) {
        this.days = days;
    }

    public void setHours(Integer hours) {
        this.hours = hours;
    }

    public void setMinutes(Integer minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(Integer seconds) {
        this.seconds = seconds;
    }

    public void setMilliseconds(Integer milliseconds) {
        this.milliseconds = milliseconds;
    }

    public void setMicroseconds(Integer microseconds) {
        this.microseconds = microseconds;
    }

    public TimePeriod years(Integer years) {
        this.years = years;
        return this;
    }

    public TimePeriod months(Integer months) {
        this.months = months;
        return this;
    }

    public TimePeriod weeks(Integer weeks) {
        this.weeks = weeks;
        return this;
    }

    public TimePeriod days(Integer days) {
        this.days = days;
        return this;
    }

    public TimePeriod hours(Integer hours) {
        this.hours = hours;
        return this;
    }

    public TimePeriod min(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public TimePeriod sec(Integer seconds) {
        this.seconds = seconds;
        return this;
    }

    public TimePeriod millis(Integer milliseconds) {
        this.milliseconds = milliseconds;
        return this;
    }

    public TimePeriod micros(Integer microseconds) {
        this.microseconds = microseconds;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimePeriod that = (TimePeriod)o;
        if (this.days != null ? !this.days.equals(that.days) : that.days != null) {
            return false;
        }
        if (this.hours != null ? !this.hours.equals(that.hours) : that.hours != null) {
            return false;
        }
        if (this.milliseconds != null ? !this.milliseconds.equals(that.milliseconds) : that.milliseconds != null) {
            return false;
        }
        if (this.microseconds != null ? !this.microseconds.equals(that.microseconds) : that.microseconds != null) {
            return false;
        }
        if (this.minutes != null ? !this.minutes.equals(that.minutes) : that.minutes != null) {
            return false;
        }
        if (this.months != null ? !this.months.equals(that.months) : that.months != null) {
            return false;
        }
        if (this.seconds != null ? !this.seconds.equals(that.seconds) : that.seconds != null) {
            return false;
        }
        if (this.weeks != null ? !this.weeks.equals(that.weeks) : that.weeks != null) {
            return false;
        }
        return !(this.years != null ? !this.years.equals(that.years) : that.years != null);
    }

    public int hashCode() {
        int result = this.years != null ? this.years.hashCode() : 0;
        result = 31 * result + (this.months != null ? this.months.hashCode() : 0);
        result = 31 * result + (this.weeks != null ? this.weeks.hashCode() : 0);
        result = 31 * result + (this.days != null ? this.days.hashCode() : 0);
        result = 31 * result + (this.hours != null ? this.hours.hashCode() : 0);
        result = 31 * result + (this.minutes != null ? this.minutes.hashCode() : 0);
        result = 31 * result + (this.seconds != null ? this.seconds.hashCode() : 0);
        result = 31 * result + (this.milliseconds != null ? this.milliseconds.hashCode() : 0);
        result = 31 * result + (this.microseconds != null ? this.microseconds.hashCode() : 0);
        return result;
    }

    public String toStringISO8601() {
        StringBuilder buf = new StringBuilder();
        if (this.years != null) {
            this.append(buf, this.years, "Y");
        }
        if (this.months != null) {
            this.append(buf, this.months, "M");
        }
        if (this.weeks != null) {
            this.append(buf, this.weeks, "W");
        }
        if (this.days != null) {
            this.append(buf, this.days, "D");
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            buf.append("T");
            if (this.hours != null) {
                this.append(buf, this.hours, "H");
            }
            if (this.minutes != null) {
                this.append(buf, this.minutes, "M");
            }
            if (this.seconds != null) {
                this.append(buf, this.seconds, "S");
            }
        }
        return buf.toString();
    }

    public Integer largestAbsoluteValue() {
        Integer absMax = null;
        if (this.years != null && (absMax == null || Math.abs(this.years) > absMax)) {
            absMax = Math.abs(this.years);
        }
        if (this.months != null && (absMax == null || Math.abs(this.months) > absMax)) {
            absMax = Math.abs(this.months);
        }
        if (this.weeks != null && (absMax == null || Math.abs(this.weeks) > absMax)) {
            absMax = Math.abs(this.weeks);
        }
        if (this.days != null && (absMax == null || Math.abs(this.days) > absMax)) {
            absMax = Math.abs(this.days);
        }
        if (this.hours != null && (absMax == null || Math.abs(this.hours) > absMax)) {
            absMax = Math.abs(this.hours);
        }
        if (this.minutes != null && (absMax == null || Math.abs(this.minutes) > absMax)) {
            absMax = Math.abs(this.minutes);
        }
        if (this.seconds != null && (absMax == null || Math.abs(this.seconds) > absMax)) {
            absMax = Math.abs(this.seconds);
        }
        if (this.milliseconds != null && (absMax == null || Math.abs(this.milliseconds) > absMax)) {
            absMax = Math.abs(this.milliseconds);
        }
        if (this.microseconds != null && (absMax == null || Math.abs(this.microseconds) > absMax)) {
            absMax = Math.abs(this.microseconds);
        }
        return absMax;
    }

    private void append(StringBuilder buf, Integer units, String unit) {
        buf.append(Integer.toString(units));
        buf.append(unit);
    }
}

