/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerByteCode;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScopeNames;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSubstitutionParamEntry;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionStaticMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatement;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementExpression;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldName;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class CodegenPackageScope {
    private final String packageName;
    private final String fieldsClassNameOptional;
    private final boolean instrumented;
    private final ConfigurationCompilerByteCode config;
    private final CodegenMethod initMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), CodegenPackageScope.class, new CodegenClassScope(true, this, null)).addParam(EPStatementInitServices.EPTYPE, EPStatementInitServices.REF.getRef()).setStatic(true);
    private int currentMemberNumber;
    private int currentSubstitutionParamNumber;
    private final LinkedHashMap<CodegenFieldName, CodegenField> fieldsNamed = new LinkedHashMap();
    private final LinkedHashMap<CodegenField, CodegenExpression> fieldsUnshared = new LinkedHashMap();
    private final LinkedHashMap<CodegenFieldSharable, CodegenField> fieldsShared = new LinkedHashMap();
    private List<CodegenSubstitutionParamEntry> substitutionParamsByNumber = new ArrayList<CodegenSubstitutionParamEntry>();
    private LinkedHashMap<String, CodegenSubstitutionParamEntry> substitutionParamsByName = new LinkedHashMap();

    public CodegenPackageScope(String packageName, String fieldsClassNameOptional, boolean instrumented, ConfigurationCompilerByteCode config) {
        this.packageName = packageName;
        this.fieldsClassNameOptional = fieldsClassNameOptional;
        this.instrumented = instrumented;
        this.config = config;
    }

    public boolean hasAnyFields() {
        return !this.getFieldsNamed().isEmpty() || !this.getFieldsUnshared().isEmpty() || !this.getSubstitutionParamsByNumber().isEmpty() || !this.getSubstitutionParamsByName().isEmpty();
    }

    public CodegenExpressionField addFieldUnshared(boolean isFinal, EPTypeClass clazz, CodegenExpression initCtorScoped) {
        if (this.fieldsClassNameOptional == null) {
            throw new IllegalStateException("No fields class name");
        }
        return CodegenExpressionBuilder.field(this.addFieldUnsharedInternal(isFinal, clazz, initCtorScoped));
    }

    public CodegenExpressionField addOrGetFieldSharable(CodegenFieldSharable sharable) {
        CodegenField member = this.fieldsShared.get(sharable);
        if (member != null) {
            return CodegenExpressionBuilder.field(member);
        }
        member = this.addFieldUnsharedInternal(true, sharable.type(), sharable.initCtorScoped());
        this.fieldsShared.put(sharable, member);
        return CodegenExpressionBuilder.field(member);
    }

    public CodegenExpressionField addOrGetFieldWellKnown(CodegenFieldName fieldName, EPTypeClass type) {
        CodegenField existing = this.fieldsNamed.get(fieldName);
        if (existing != null) {
            if (!existing.getType().equals(type)) {
                throw new IllegalStateException("Field '" + fieldName + "' already registered with a different type, registered with " + existing.getType().toFullName() + " but provided " + type.toFullName());
            }
            return CodegenExpressionBuilder.field(existing);
        }
        CodegenField field = new CodegenField(this.fieldsClassNameOptional, fieldName.getName(), type, false);
        this.fieldsNamed.put(fieldName, field);
        return CodegenExpressionBuilder.field(field);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public CodegenMethod getInitMethod() {
        return this.initMethod;
    }

    public LinkedHashMap<CodegenFieldName, CodegenField> getFieldsNamed() {
        return this.fieldsNamed;
    }

    public boolean hasAssignableStatementFields() {
        return !this.fieldsNamed.isEmpty();
    }

    public LinkedHashMap<CodegenField, CodegenExpression> getFieldsUnshared() {
        return this.fieldsUnshared;
    }

    public String getFieldsClassNameOptional() {
        return this.fieldsClassNameOptional;
    }

    public List<CodegenSubstitutionParamEntry> getSubstitutionParamsByNumber() {
        return this.substitutionParamsByNumber;
    }

    public LinkedHashMap<String, CodegenSubstitutionParamEntry> getSubstitutionParamsByName() {
        return this.substitutionParamsByName;
    }

    private CodegenField addFieldUnsharedInternal(boolean isFinal, EPTypeClass type, CodegenExpression initCtorScoped) {
        int memberNumber = this.currentMemberNumber++;
        String name = CodegenPackageScopeNames.anyField(memberNumber);
        CodegenField member = new CodegenField(this.fieldsClassNameOptional, name, type, isFinal);
        this.fieldsUnshared.put(member, initCtorScoped);
        return member;
    }

    public CodegenField addSubstitutionParameter(String name, EPTypeClass type) {
        CodegenField member;
        CodegenSubstitutionParamEntry entry;
        boolean mixed = false;
        if (name == null) {
            if (!this.substitutionParamsByName.isEmpty()) {
                mixed = true;
            }
        } else if (!this.substitutionParamsByNumber.isEmpty()) {
            mixed = true;
        }
        if (mixed) {
            throw new IllegalArgumentException("Mixing named and unnamed substitution parameters is not allowed");
        }
        if (name != null && (entry = this.substitutionParamsByName.get(name)) != null && !JavaClassHelper.isSubclassOrImplementsInterface((EPType)type, entry.getType())) {
            throw new IllegalArgumentException("Substitution parameter '" + name + "' of type '" + entry.getType() + "' cannot be assigned type '" + type + "'");
        }
        if (name == null) {
            int assigned = ++this.currentSubstitutionParamNumber;
            String fieldName = CodegenPackageScopeNames.anySubstitutionParam(assigned);
            member = new CodegenField(this.fieldsClassNameOptional, fieldName, type, false);
            this.substitutionParamsByNumber.add(new CodegenSubstitutionParamEntry(member, name, type));
        } else {
            CodegenSubstitutionParamEntry existing = this.substitutionParamsByName.get(name);
            if (existing == null) {
                int assigned = ++this.currentSubstitutionParamNumber;
                String fieldName = CodegenPackageScopeNames.anySubstitutionParam(assigned);
                member = new CodegenField(this.fieldsClassNameOptional, fieldName, type, false);
                this.substitutionParamsByName.put(name, new CodegenSubstitutionParamEntry(member, name, type));
            } else {
                member = existing.getField();
            }
        }
        return member;
    }

    public boolean isInstrumented() {
        return this.instrumented;
    }

    public boolean isHasSubstitution() {
        return !this.substitutionParamsByNumber.isEmpty() || !this.substitutionParamsByName.isEmpty();
    }

    public ConfigurationCompilerByteCode getConfig() {
        return this.config;
    }

    public void rewriteStatementFieldUse(List<CodegenClass> classes) {
        if (this.getFieldsClassNameOptional() != null && !this.hasAnyFields()) {
            CodegenPackageScope.rewriteProviderNoFieldInit(classes, this.getFieldsClassNameOptional());
        }
    }

    private static void rewriteProviderNoFieldInit(List<CodegenClass> classes, String fieldClassName) {
        for (CodegenClass clazz : classes) {
            if (clazz.getClassType() != CodegenClassType.FAFQUERYMETHODPROVIDER && clazz.getClassType() != CodegenClassType.STATEMENTAIFACTORYPROVIDER) continue;
            Iterator<CodegenStatement> it = clazz.getOptionalCtor().getBlock().getStatements().iterator();
            while (it.hasNext()) {
                CodegenExpressionStaticMethod staticMethod;
                CodegenStatementExpression expression;
                CodegenStatement statement = it.next();
                if (!(statement instanceof CodegenStatementExpression) || !((expression = (CodegenStatementExpression)statement).getExpression() instanceof CodegenExpressionStaticMethod) || (staticMethod = (CodegenExpressionStaticMethod)expression.getExpression()).getTargetClassName() == null || !staticMethod.getTargetClassName().equals(fieldClassName)) continue;
                it.remove();
            }
        }
    }
}

