/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSetterBuilderItemConsumer;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class CodegenSetterBuilder {
    private final Class originator;
    private final String refName;
    private final CodegenClassScope classScope;
    private final boolean methodProvided;
    private CodegenMethod method;
    private boolean closed;

    public CodegenSetterBuilder(EPTypeClass returnType, Class originator, String refName, CodegenMethodScope parent, CodegenClassScope classScope) {
        this.originator = originator;
        this.refName = refName;
        this.classScope = classScope;
        this.methodProvided = false;
        this.method = parent.makeChild(returnType, originator, (CodegenScope)classScope);
        this.method.getBlock().declareVarNewInstance(returnType, refName);
    }

    public CodegenSetterBuilder(EPTypeClass returnType, Class originator, String refName, CodegenClassScope classScope, CodegenMethod method) {
        this.originator = originator;
        this.refName = refName;
        this.classScope = classScope;
        this.method = method;
        this.methodProvided = true;
        method.getBlock().declareVarNewInstance(returnType, refName);
    }

    public CodegenSetterBuilder(EPTypeClass returnType, Class originator, String refName, CodegenClassScope classScope, CodegenMethod method, CodegenExpression initializer) {
        this.originator = originator;
        this.refName = refName;
        this.classScope = classScope;
        this.method = method;
        this.methodProvided = true;
        method.getBlock().declareVar(returnType, refName, initializer);
    }

    public CodegenSetterBuilder constantExplicit(String name, Object value) {
        if (value instanceof CodegenExpression) {
            throw new IllegalArgumentException("Expected a non-expression value, received " + value);
        }
        return this.setValue(name, value == null ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.constant(value));
    }

    public CodegenSetterBuilder constantDefaultChecked(String name, boolean value) {
        if (!value) {
            return this;
        }
        return this.setValue(name, CodegenExpressionBuilder.constant(value));
    }

    public CodegenSetterBuilder constantDefaultChecked(String name, int value) {
        if (value == 0) {
            return this;
        }
        return this.setValue(name, CodegenExpressionBuilder.constant(value));
    }

    public CodegenSetterBuilder constantDefaultChecked(String name, Boolean value) {
        return this.constantDefaultCheckedObj(name, value);
    }

    public CodegenSetterBuilder constantDefaultChecked(String name, Integer value) {
        return this.constantDefaultCheckedObj(name, value);
    }

    public CodegenSetterBuilder constantDefaultCheckedObj(String name, Object value) {
        if (value == null) {
            return this;
        }
        return this.setValue(name, CodegenExpressionBuilder.constant(value));
    }

    public CodegenSetterBuilder expressionDefaultChecked(String name, CodegenExpression expression) {
        if (expression.equals(CodegenExpressionBuilder.constantNull())) {
            return this;
        }
        return this.setValue(name, expression);
    }

    public CodegenSetterBuilder expression(String name, CodegenExpression expression) {
        return this.setValue(name, expression);
    }

    public CodegenSetterBuilder method(String name, Function<CodegenMethod, CodegenExpression> expressionFunc) {
        CodegenExpression expression = expressionFunc.apply(this.method);
        return this.setValue(name, expression == null ? CodegenExpressionBuilder.constantNull() : expression);
    }

    public CodegenSetterBuilder mapOfConstants(String name, Map<String, ?> values) {
        CodegenSetterBuilderItemConsumer consumer = new CodegenSetterBuilderItemConsumer(){

            public CodegenExpression apply(Object o, CodegenMethodScope parent, CodegenClassScope scope) {
                return CodegenExpressionBuilder.constant(o);
            }
        };
        return this.setValue(name, CodegenSetterBuilder.buildMap(values, consumer, this.originator, this.method, this.classScope));
    }

    public <I> CodegenSetterBuilder map(String name, Map<String, I> values, CodegenSetterBuilderItemConsumer<I> consumer) {
        return this.setValue(name, CodegenSetterBuilder.buildMap(values, consumer, this.originator, this.method, this.classScope));
    }

    public CodegenExpressionRef getRefName() {
        return CodegenExpressionBuilder.ref(this.refName);
    }

    public CodegenExpression build() {
        if (this.methodProvided) {
            throw new IllegalStateException("Builder build is reserved for the case when the method is not already provided");
        }
        if (this.closed) {
            throw new IllegalStateException("Builder already completed build");
        }
        this.closed = true;
        this.method.getBlock().methodReturn(CodegenExpressionBuilder.ref(this.refName));
        return CodegenExpressionBuilder.localMethod(this.method, new CodegenExpression[0]);
    }

    public CodegenMethod getMethod() {
        return this.method;
    }

    private static <V> CodegenExpression buildMap(Map<String, V> map, CodegenSetterBuilderItemConsumer<V> valueConsumer, Class originator, CodegenMethod method, CodegenClassScope classScope) {
        if (map == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (map.isEmpty()) {
            return CodegenExpressionBuilder.staticMethod(Collections.class, "emptyMap", new CodegenExpression[0]);
        }
        CodegenMethod child = method.makeChild(EPTypePremade.MAP.getEPType(), originator, (CodegenScope)classScope);
        if (map.size() == 1) {
            Map.Entry<String, V> single = map.entrySet().iterator().next();
            CodegenExpression value = CodegenSetterBuilder.buildMapValue(single.getValue(), valueConsumer, originator, child, classScope);
            child.getBlock().methodReturn(CodegenExpressionBuilder.staticMethod(Collections.class, "singletonMap", CodegenExpressionBuilder.constant(single.getKey()), value));
        } else {
            child.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "map", CodegenExpressionBuilder.newInstance(EPTypePremade.LINKEDHASHMAP.getEPType(), CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(map.size()))));
            for (Map.Entry<String, V> entry : map.entrySet()) {
                CodegenExpression value = CodegenSetterBuilder.buildMapValue(entry.getValue(), valueConsumer, originator, child, classScope);
                child.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("map"), "put", CodegenExpressionBuilder.constant(entry.getKey()), value);
            }
            child.getBlock().methodReturn(CodegenExpressionBuilder.ref("map"));
        }
        return CodegenExpressionBuilder.localMethod(child, new CodegenExpression[0]);
    }

    private static <V> CodegenExpression buildMapValue(V value, CodegenSetterBuilderItemConsumer<V> valueConsumer, Class originator, CodegenMethod method, CodegenClassScope classScope) {
        if (value instanceof Map) {
            return CodegenSetterBuilder.buildMap((Map)value, valueConsumer, originator, method, classScope);
        }
        return valueConsumer.apply(value, method, classScope);
    }

    private CodegenSetterBuilder setValue(String name, CodegenExpression expression) {
        this.method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(this.refName), "set" + this.getBeanCap(name), expression);
        return this;
    }

    private String getBeanCap(String name) {
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

