/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.base;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class CodegenSubstitutionParamEntry {
    private final CodegenField field;
    private final String name;
    private final EPTypeClass type;

    public CodegenSubstitutionParamEntry(CodegenField field, String name, EPTypeClass type) {
        this.field = field;
        this.name = name;
        this.type = type;
    }

    public CodegenField getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public EPTypeClass getType() {
        return this.type;
    }

    public static void codegenSetterMethod(CodegenClassScope classScope, CodegenMethod method) {
        int targetMethodComplexity = Math.max(64, classScope.getPackageScope().getConfig().getInternalUseOnlyMaxMethodComplexity());
        List<CodegenSubstitutionParamEntry> numbered = classScope.getPackageScope().getSubstitutionParamsByNumber();
        LinkedHashMap<String, CodegenSubstitutionParamEntry> named = classScope.getPackageScope().getSubstitutionParamsByName();
        if (!numbered.isEmpty() && !named.isEmpty()) {
            throw new IllegalStateException("Both named and numbered substitution parameters are non-empty");
        }
        List<CodegenSubstitutionParamEntry> fields = !numbered.isEmpty() ? numbered : new ArrayList<CodegenSubstitutionParamEntry>(named.values());
        if (fields.size() <= targetMethodComplexity) {
            CodegenSubstitutionParamEntry.populateSet(method, fields, 0);
            return;
        }
        List<List<CodegenSubstitutionParamEntry>> assignments = CollectionUtil.subdivide(fields, targetMethodComplexity);
        ArrayList<CodegenMethod> leafs = new ArrayList<CodegenMethod>(assignments.size());
        for (int i = 0; i < assignments.size(); ++i) {
            List<CodegenSubstitutionParamEntry> assignment = assignments.get(i);
            CodegenMethod leaf = method.makeChild(EPTypePremade.VOID.getEPType(), CodegenSubstitutionParamEntry.class, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "index").addParam(EPTypePremade.OBJECT.getEPType(), "value");
            CodegenSubstitutionParamEntry.populateSet(leaf, assignment, i * targetMethodComplexity);
            leafs.add(leaf);
        }
        method.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "lidx", CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("index"), "-", CodegenExpressionBuilder.constant(1)), "/", CodegenExpressionBuilder.constant(targetMethodComplexity)));
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("lidx"), assignments.size(), false);
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i].localMethod((CodegenMethod)leafs.get(i), CodegenExpressionBuilder.ref("index"), CodegenExpressionBuilder.ref("value"));
        }
    }

    private static void populateSet(CodegenMethod method, List<CodegenSubstitutionParamEntry> fields, int offset) {
        method.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "zidx", CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("index"), "-", CodegenExpressionBuilder.constant(1)));
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("zidx"), fields.size(), false, offset);
        for (int i = 0; i < blocks.length; ++i) {
            CodegenSubstitutionParamEntry param = fields.get(i);
            blocks[i].assignRef(CodegenExpressionBuilder.field(param.getField()), CodegenExpressionBuilder.cast(JavaClassHelper.getBoxedType(param.getType()), (CodegenExpression)CodegenExpressionBuilder.ref("value")));
        }
    }
}

