/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassInterfacesAndExtension;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CodegenClass {
    private final CodegenClassType classType;
    private final String packageName;
    private final String className;
    private final CodegenClassInterfacesAndExtension supers = new CodegenClassInterfacesAndExtension();
    private final CodegenCtor optionalCtor;
    private final List<CodegenTypedParam> explicitMembers;
    private final CodegenClassMethods methods;
    private final List<CodegenInnerClass> innerClasses;

    public CodegenClass(CodegenClassType classType, EPTypeClass optionalInterfaceImplemented, String className, CodegenClassScope codegenClassScope, List<CodegenTypedParam> explicitMembers, CodegenCtor optionalCtor, CodegenClassMethods methods, List<CodegenInnerClass> innerClasses) {
        this(classType, className, codegenClassScope, explicitMembers, optionalCtor, methods, innerClasses);
        if (optionalInterfaceImplemented != null) {
            if (optionalInterfaceImplemented.getType().isInterface()) {
                this.supers.addInterfaceImplemented(optionalInterfaceImplemented);
            } else {
                this.supers.setClassExtended(optionalInterfaceImplemented);
            }
        }
    }

    public CodegenClass(CodegenClassType classType, String className, CodegenClassScope codegenClassScope, List<CodegenTypedParam> explicitMembers, CodegenCtor optionalCtor, CodegenClassMethods methods, List<CodegenInnerClass> innerClasses) {
        this.classType = classType;
        this.packageName = codegenClassScope.getPackageScope().getPackageName();
        this.className = className;
        this.explicitMembers = explicitMembers;
        this.optionalCtor = optionalCtor;
        this.methods = methods;
        ArrayList<CodegenInnerClass> allInnerClasses = new ArrayList<CodegenInnerClass>(innerClasses);
        allInnerClasses.addAll(codegenClassScope.getAdditionalInnerClasses());
        this.innerClasses = allInnerClasses;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public CodegenClassInterfacesAndExtension getSupers() {
        return this.supers;
    }

    public List<CodegenTypedParam> getExplicitMembers() {
        return this.explicitMembers;
    }

    public List<CodegenMethodWGraph> getPublicMethods() {
        return this.methods.getPublicMethods();
    }

    public List<CodegenMethodWGraph> getPrivateMethods() {
        return this.methods.getPrivateMethods();
    }

    public List<CodegenInnerClass> getInnerClasses() {
        return this.innerClasses;
    }

    public void addInnerClass(CodegenInnerClass innerClass) {
        this.innerClasses.add(innerClass);
    }

    public CodegenCtor getOptionalCtor() {
        return this.optionalCtor;
    }

    public CodegenClassType getClassType() {
        return this.classType;
    }

    public Set<Class> getReferencedClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        CodegenClass.addReferencedClasses(this.supers, this.methods, classes);
        CodegenClass.addReferencedClasses(this.explicitMembers, classes);
        if (this.optionalCtor != null) {
            this.optionalCtor.mergeClasses(classes);
        }
        for (CodegenInnerClass inner : this.innerClasses) {
            CodegenClass.addReferencedClasses(inner.getSupers(), inner.getMethods(), classes);
            CodegenClass.addReferencedClasses(inner.getExplicitMembers(), classes);
            if (inner.getCtor() == null) continue;
            inner.getCtor().mergeClasses(classes);
        }
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            if (clazz == null) {
                it.remove();
                continue;
            }
            Package pack = clazz.getPackage();
            if (pack != null && !pack.getName().equals("java.lang")) continue;
            it.remove();
        }
        return classes;
    }

    public String toString() {
        return "CodegenClass{className='" + this.className + "'}";
    }

    private static void addReferencedClasses(CodegenClassInterfacesAndExtension supers, CodegenClassMethods methods, Set<Class> classes) {
        supers.addReferenced(classes);
        for (CodegenMethodWGraph publicMethod : methods.getPublicMethods()) {
            publicMethod.mergeClasses(classes);
        }
        for (CodegenMethodWGraph privateMethod : methods.getPrivateMethods()) {
            privateMethod.mergeClasses(classes);
        }
    }

    private static void addReferencedClasses(List<CodegenTypedParam> names, Set<Class> classes) {
        for (CodegenTypedParam param : names) {
            param.mergeClasses(classes);
        }
    }
}

