/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassInterfacesAndExtension;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import java.util.List;

public class CodegenInnerClass {
    private final String className;
    private final CodegenClassInterfacesAndExtension supers = new CodegenClassInterfacesAndExtension();
    private final CodegenCtor ctor;
    private final List<CodegenTypedParam> explicitMembers;
    private final CodegenClassMethods methods;

    public CodegenInnerClass(String className, EPTypeClass optionalInterfaceImplemented, CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassMethods methods) {
        this(className, ctor, explicitMembers, methods);
        if (optionalInterfaceImplemented != null) {
            if (optionalInterfaceImplemented.getType().isInterface()) {
                this.supers.addInterfaceImplemented(optionalInterfaceImplemented);
            } else {
                this.supers.setClassExtended(optionalInterfaceImplemented);
            }
        }
    }

    public CodegenInnerClass(String className, CodegenCtor ctor, List<CodegenTypedParam> explicitMembers, CodegenClassMethods methods) {
        this.className = className;
        this.ctor = ctor;
        this.explicitMembers = explicitMembers;
        this.methods = methods;
    }

    public String getClassName() {
        return this.className;
    }

    public CodegenClassInterfacesAndExtension getSupers() {
        return this.supers;
    }

    public CodegenClassMethods getMethods() {
        return this.methods;
    }

    public CodegenCtor getCtor() {
        return this.ctor;
    }

    public List<CodegenTypedParam> getExplicitMembers() {
        return this.explicitMembers;
    }

    public String toString() {
        return "CodegenInnerClass{className='" + this.className + "'}";
    }

    public void addInterfaceImplemented(EPTypeClass eptype) {
        this.supers.addInterfaceImplemented(eptype);
    }
}

