/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodFootprint;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenMethodWGraph {
    private final String name;
    private final CodegenMethodFootprint footprint;
    private final CodegenBlock block;
    private final boolean isPublic;
    private final List<EPTypeClass> thrown;
    private final CodegenMethod originator;
    private boolean isStatic;

    public CodegenMethodWGraph(String name, CodegenMethodFootprint footprint, CodegenBlock block, boolean isPublic, List<EPTypeClass> thrown, CodegenMethod originator) {
        this.name = name;
        this.footprint = footprint;
        this.block = block;
        this.isPublic = isPublic;
        this.thrown = thrown;
        this.originator = originator;
    }

    public void mergeClasses(Set<Class> classes) {
        this.footprint.mergeClasses(classes);
        this.block.mergeClasses(classes);
        if (this.thrown != null && !this.thrown.isEmpty()) {
            for (EPTypeClass clazz : this.thrown) {
                clazz.traverseClasses(classes::add);
            }
        }
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isPublic, boolean isInnerClass, CodegenIndent indent, int additionalIndent) {
        if (this.footprint.getOptionalComment() != null) {
            indent.indent(builder, 1 + additionalIndent);
            builder.append("// ").append(this.footprint.getOptionalComment()).append("\n");
        }
        indent.indent(builder, 1 + additionalIndent);
        if (isPublic) {
            builder.append("public ");
        }
        if (this.isStatic) {
            builder.append("static ");
        }
        if (this.footprint.getReturnType() != null) {
            CodeGenerationHelper.appendClassName(builder, this.footprint.getReturnType(), imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.footprint.getReturnTypeName());
        }
        builder.append(" ").append(this.name);
        builder.append("(");
        String delimiter = "";
        for (CodegenNamedParam param : this.footprint.getParams()) {
            builder.append(delimiter);
            param.render(builder, imports);
            delimiter = ",";
        }
        builder.append(")");
        if (!this.thrown.isEmpty()) {
            builder.append(" throws ");
            String delimiterThrown = "";
            for (EPTypeClass ex : this.thrown) {
                builder.append(delimiterThrown);
                CodeGenerationHelper.appendClassName(builder, ex, imports);
                delimiterThrown = ",";
            }
        }
        builder.append("{\n");
        this.block.render(builder, imports, isInnerClass, 2 + additionalIndent, indent);
        indent.indent(builder, 1 + additionalIndent);
        builder.append("}\n");
    }

    public String getName() {
        return this.name;
    }

    public CodegenMethodFootprint getFootprint() {
        return this.footprint;
    }

    public CodegenBlock getBlock() {
        return this.block;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public CodegenMethodWGraph setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public CodegenMethod getOriginator() {
        return this.originator;
    }

    public String toString() {
        return "CodegenMethodWGraph{name='" + this.name + "'}";
    }
}

