/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenNamedParam {
    private final EPTypeClass type;
    private final String typeName;
    private final String name;

    public CodegenNamedParam(EPTypeClass type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("Invalid null type");
        }
        this.type = type;
        this.typeName = null;
        this.name = name;
    }

    public CodegenNamedParam(String typeName, String name) {
        if (typeName == null) {
            throw new IllegalArgumentException("Invalid null type");
        }
        this.type = null;
        this.typeName = typeName;
        this.name = name;
    }

    public CodegenNamedParam(EPTypeClass type, CodegenExpressionRef name) {
        this(type, name.getRef());
    }

    public EPTypeClass getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void render(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(2);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(2);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(3);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree, EPTypeClass typeFour, String nameFour) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(4);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        result.add(new CodegenNamedParam(typeFour, nameFour));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree, EPTypeClass typeFour, String nameFour, EPTypeClass typeFive, String nameFive) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(5);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        result.add(new CodegenNamedParam(typeFour, nameFour));
        result.add(new CodegenNamedParam(typeFive, nameFive));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree, EPTypeClass typeFour, String nameFour, EPTypeClass typeFive, String nameFive, EPTypeClass typeSix, String nameSix) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>(6);
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        result.add(new CodegenNamedParam(typeFour, nameFour));
        result.add(new CodegenNamedParam(typeFive, nameFive));
        result.add(new CodegenNamedParam(typeSix, nameSix));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree, EPTypeClass typeFour, String nameFour, EPTypeClass typeFive, String nameFive, EPTypeClass typeSix, String nameSix, EPTypeClass typeSeven, String nameSeven) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>();
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        result.add(new CodegenNamedParam(typeFour, nameFour));
        result.add(new CodegenNamedParam(typeFive, nameFive));
        result.add(new CodegenNamedParam(typeSix, nameSix));
        result.add(new CodegenNamedParam(typeSeven, nameSeven));
        return result;
    }

    public static List<CodegenNamedParam> from(EPTypeClass typeOne, String nameOne, EPTypeClass typeTwo, String nameTwo, EPTypeClass typeThree, String nameThree, EPTypeClass typeFour, String nameFour, EPTypeClass typeFive, String nameFive, EPTypeClass typeSix, String nameSix, EPTypeClass typeSeven, String nameSeven, EPTypeClass typeEight, String nameEight) {
        ArrayList<CodegenNamedParam> result = new ArrayList<CodegenNamedParam>();
        result.add(new CodegenNamedParam(typeOne, nameOne));
        result.add(new CodegenNamedParam(typeTwo, nameTwo));
        result.add(new CodegenNamedParam(typeThree, nameThree));
        result.add(new CodegenNamedParam(typeFour, nameFour));
        result.add(new CodegenNamedParam(typeFive, nameFive));
        result.add(new CodegenNamedParam(typeSix, nameSix));
        result.add(new CodegenNamedParam(typeSeven, nameSeven));
        result.add(new CodegenNamedParam(typeEight, nameEight));
        return result;
    }

    public static void render(StringBuilder builder, List<CodegenNamedParam> params, Map<Class, String> imports) {
        String delimiter = "";
        for (CodegenNamedParam param : params) {
            builder.append(delimiter);
            param.render(builder, imports);
            delimiter = ",";
        }
    }

    public void mergeClasses(Set<Class> classes) {
        if (this.type != null) {
            this.type.traverseClasses(classes::add);
        }
    }

    public static void render(StringBuilder builder, Map<Class, String> imports, List<CodegenNamedParam> params) {
        String delimiter = "";
        for (CodegenNamedParam param : params) {
            builder.append(delimiter);
            param.render(builder, imports);
            delimiter = ",";
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenNamedParam param = (CodegenNamedParam)o;
        if (!this.type.equals(param.type)) {
            return false;
        }
        return this.name.equals(param.name);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

