/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.core;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;

public class CodegenTypedParam {
    private final String typeName;
    private final EPTypeClass type;
    private final String name;
    private final boolean memberWhenCtorParam;
    private final boolean isPublic;
    private boolean isFinal = true;
    private boolean isStatic = false;
    private CodegenExpression initializer = null;

    public CodegenTypedParam(String typeName, EPTypeClass type, String name, boolean memberWhenCtorParam, boolean isPublic) {
        if (type == null && typeName == null) {
            throw new IllegalArgumentException("Invalid null type");
        }
        this.typeName = typeName;
        this.type = type;
        this.name = name;
        this.memberWhenCtorParam = memberWhenCtorParam;
        this.isPublic = isPublic;
    }

    public CodegenTypedParam(String typeName, EPTypeClass type, String name) {
        this(typeName, type, name, true, false);
    }

    public CodegenTypedParam(EPTypeClass type, String name) {
        this(null, type, name);
    }

    public CodegenTypedParam(EPTypeClass type, String name, boolean memberWhenCtorParam) {
        this(null, type, name, memberWhenCtorParam, false);
    }

    public CodegenTypedParam(EPTypeClass type, String name, boolean memberWhenCtorParam, boolean isPublic) {
        this(null, type, name, memberWhenCtorParam, isPublic);
    }

    public CodegenTypedParam(String typeName, String name, boolean memberWhenCtorParam, boolean isPublic) {
        this(typeName, null, name, memberWhenCtorParam, isPublic);
    }

    public CodegenTypedParam(String type, String name) {
        this(type, null, name);
    }

    public CodegenTypedParam setFinal(boolean aFinal) {
        this.isFinal = aFinal;
        return this;
    }

    public CodegenTypedParam setStatic(boolean aStatic) {
        this.isStatic = aStatic;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void renderAsParameter(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void mergeClasses(Set<Class> classes) {
        if (this.type != null) {
            this.type.traverseClasses(classes::add);
        }
        if (this.initializer != null) {
            this.initializer.mergeClasses(classes);
        }
    }

    public void renderAsMember(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.typeName);
        }
        builder.append(" ").append(this.name);
    }

    public void renderType(StringBuilder builder, Map<Class, String> imports) {
        if (this.type != null) {
            CodeGenerationHelper.appendClassName(builder, this.type, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.typeName);
        }
    }

    public boolean isMemberWhenCtorParam() {
        return this.memberWhenCtorParam;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public CodegenExpression getInitializer() {
        return this.initializer;
    }

    public CodegenTypedParam setInitializer(CodegenExpression initializer) {
        this.initializer = initializer;
        return this;
    }

    public String toString() {
        return "CodegenTypedParam{typeName='" + this.typeName + "', type=" + this.type + ", name='" + this.name + "', memberWhenCtorParam=" + this.memberWhenCtorParam + ", isPublic=" + this.isPublic + ", isFinal=" + this.isFinal + ", isStatic=" + this.isStatic + ", initializer=" + this.initializer + "}";
    }

    public void renderInitializer(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.initializer != null) {
            builder.append("=");
            this.initializer.render(builder, imports, isInnerClass);
        }
    }
}

