/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenField;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionAndOr;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionArrayAtIndex;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionArrayLength;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionAssign;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionCastExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionCastRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionCastUnderlying;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConcat;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConditional;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConstant;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConstantFalse;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConstantNull;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionConstantTrue;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionEnumOrPublicConstantValue;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionEqualsNull;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionEqualsReference;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionExprDotMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionExprDotMethodChain;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionExprDotName;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionExprDotUnderlying;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionIncrementDecrement;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionInstanceOf;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionLocalMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMemberWCol;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewArrayByLength;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewArrayWithInit;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewInstance;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewInstanceInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNoOp;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNot;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionOp;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionStaticMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenLocalMethodBuilder;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionBuilder {
    public static CodegenExpressionRef ref(String ref) {
        return new CodegenExpressionRef(ref);
    }

    public static CodegenExpressionMember member(String ref) {
        return new CodegenExpressionMember(ref);
    }

    public static CodegenExpressionMemberWCol memberCol(String ref, int column) {
        return new CodegenExpressionMemberWCol(ref, column);
    }

    public static CodegenExpression op(CodegenExpression left, String expressionText, CodegenExpression right) {
        return new CodegenExpressionOp(left, expressionText, right);
    }

    public static CodegenExpression and(CodegenExpression first, CodegenExpression second, CodegenExpression ... more) {
        return new CodegenExpressionAndOr(true, first, second, more);
    }

    public static CodegenExpression or(CodegenExpression first, CodegenExpression second, CodegenExpression ... more) {
        return new CodegenExpressionAndOr(false, first, second, more);
    }

    public static CodegenExpression concat(CodegenExpression ... stringExpressions) {
        return new CodegenExpressionConcat(stringExpressions);
    }

    public static CodegenExpressionExprDotName exprDotName(CodegenExpression left, String name) {
        return new CodegenExpressionExprDotName(left, name);
    }

    public static CodegenExpression exprDotMethod(CodegenExpression expression, String method, CodegenExpression ... params) {
        return new CodegenExpressionExprDotMethod(expression, method, params);
    }

    public static CodegenExpression enumValue(Class enumType, String enumValue) {
        return new CodegenExpressionEnumOrPublicConstantValue(enumType, enumValue);
    }

    public static CodegenExpression publicConstValue(Class enumType, String enumValue) {
        return new CodegenExpressionEnumOrPublicConstantValue(enumType, enumValue);
    }

    public static CodegenExpression publicConstValue(EPTypeClass enumType, String enumValue) {
        return CodegenExpressionBuilder.publicConstValue(enumType.getType(), enumValue);
    }

    public static CodegenExpression publicConstValue(String enumType, String enumValue) {
        return new CodegenExpressionEnumOrPublicConstantValue(enumType, enumValue);
    }

    public static CodegenExpressionExprDotMethodChain exprDotMethodChain(CodegenExpression expression) {
        return new CodegenExpressionExprDotMethodChain(expression);
    }

    public static CodegenExpression exprDotUnderlying(CodegenExpression expression) {
        return new CodegenExpressionExprDotUnderlying(expression);
    }

    public static CodegenLocalMethodBuilder localMethodBuild(CodegenMethod methodNode) {
        return new CodegenLocalMethodBuilder(methodNode);
    }

    public static CodegenExpressionLocalMethod localMethod(CodegenMethod methodNode, CodegenExpression ... parameters) {
        return new CodegenExpressionLocalMethod(methodNode, Arrays.asList(parameters));
    }

    public static CodegenExpression constantTrue() {
        return CodegenExpressionConstantTrue.INSTANCE;
    }

    public static CodegenExpression constantFalse() {
        return CodegenExpressionConstantFalse.INSTANCE;
    }

    public static CodegenExpression constantNull() {
        return CodegenExpressionConstantNull.INSTANCE;
    }

    public static CodegenExpression constant(Object constant) {
        return new CodegenExpressionConstant(constant);
    }

    public static CodegenExpression mapOfConstant(Map<String, Object> constants) {
        if (constants == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        CodegenExpression[] expressions = new CodegenExpression[constants.size() * 2];
        int count = 0;
        for (Map.Entry<String, Object> entry : constants.entrySet()) {
            expressions[count] = CodegenExpressionBuilder.constant(entry.getKey());
            expressions[count + 1] = CodegenExpressionBuilder.constant(entry.getValue());
            count += 2;
        }
        return CodegenExpressionBuilder.staticMethod(CollectionUtil.class, "buildMap", expressions);
    }

    public static CodegenExpressionField field(CodegenField field) {
        return new CodegenExpressionField(field);
    }

    public static CodegenExpressionNewAnonymousClass newAnonymousClass(CodegenBlock parentBlock, EPTypeClass interfaceOrSuperClass, List<CodegenExpression> ctorParams) {
        return new CodegenExpressionNewAnonymousClass(parentBlock, interfaceOrSuperClass, ctorParams);
    }

    public static CodegenExpressionNewAnonymousClass newAnonymousClass(CodegenBlock parentBlock, EPTypeClass interfaceOrSuperClass) {
        return new CodegenExpressionNewAnonymousClass(parentBlock, interfaceOrSuperClass, Collections.emptyList());
    }

    public static CodegenExpression noop() {
        return CodegenExpressionNoOp.INSTANCE;
    }

    public static CodegenExpression castUnderlying(EPTypeClass clazz, CodegenExpression expression) {
        return new CodegenExpressionCastUnderlying(clazz, expression);
    }

    public static CodegenExpression castUnderlying(String clazz, CodegenExpression expression) {
        return new CodegenExpressionCastUnderlying(clazz, expression);
    }

    public static CodegenExpression instanceOf(CodegenExpression lhs, EPTypeClass clazz) {
        return new CodegenExpressionInstanceOf(lhs, clazz, false);
    }

    public static CodegenExpression notInstanceOf(CodegenExpression lhs, EPTypeClass clazz) {
        return new CodegenExpressionInstanceOf(lhs, clazz, true);
    }

    public static CodegenExpression castRef(EPTypeClass clazz, String ref) {
        return new CodegenExpressionCastRef(clazz, ref);
    }

    public static CodegenExpression incrementRef(String ref) {
        return CodegenExpressionBuilder.increment(CodegenExpressionBuilder.ref(ref));
    }

    public static CodegenExpression increment(CodegenExpression expression) {
        return new CodegenExpressionIncrementDecrement(expression, true);
    }

    public static CodegenExpression decrementRef(String ref) {
        return CodegenExpressionBuilder.decrement(CodegenExpressionBuilder.ref(ref));
    }

    public static CodegenExpression decrement(CodegenExpression expression) {
        return new CodegenExpressionIncrementDecrement(expression, false);
    }

    public static CodegenExpression conditional(CodegenExpression condition, CodegenExpression expressionTrue, CodegenExpression expressionFalse) {
        return new CodegenExpressionConditional(condition, expressionTrue, expressionFalse);
    }

    public static CodegenExpression not(CodegenExpression expression) {
        return new CodegenExpressionNot(true, expression);
    }

    public static CodegenExpression notOptional(boolean isNot, CodegenExpression expression) {
        return new CodegenExpressionNot(isNot, expression);
    }

    public static CodegenExpression cast(EPTypeClass clazz, CodegenExpression expression) {
        return new CodegenExpressionCastExpression(clazz, expression);
    }

    public static CodegenExpression cast(String typeName, CodegenExpression expression) {
        return new CodegenExpressionCastExpression(typeName, expression);
    }

    public static CodegenExpression notEqualsNull(CodegenExpression lhs) {
        return new CodegenExpressionEqualsNull(lhs, true);
    }

    public static CodegenExpression equalsNull(CodegenExpression lhs) {
        return new CodegenExpressionEqualsNull(lhs, false);
    }

    public static CodegenExpression equalsIdentity(CodegenExpression lhs, CodegenExpression rhs) {
        return new CodegenExpressionEqualsReference(lhs, rhs, false);
    }

    public static CodegenExpression staticMethod(Class clazz, String method, CodegenExpression ... params) {
        return new CodegenExpressionStaticMethod(clazz, method, params);
    }

    public static CodegenExpression staticMethod(String clazz, String method, CodegenExpression ... params) {
        return new CodegenExpressionStaticMethod(clazz, method, params);
    }

    public static CodegenExpression clazz(Class clazz) {
        return new CodegenExpressionClass(clazz);
    }

    public static CodegenExpression arrayAtIndex(CodegenExpression expression, CodegenExpression index) {
        return new CodegenExpressionArrayAtIndex(expression, index);
    }

    public static CodegenExpression assign(CodegenExpression lhs, CodegenExpression rhs) {
        return new CodegenExpressionAssign(lhs, rhs);
    }

    public static CodegenExpression arrayLength(CodegenExpression expression) {
        return new CodegenExpressionArrayLength(expression);
    }

    public static CodegenExpression newInstance(EPTypeClass clazz, CodegenExpression ... params) {
        return new CodegenExpressionNewInstance(clazz, params);
    }

    public static CodegenExpression newInstance(String name, CodegenExpression ... params) {
        return new CodegenExpressionNewInstanceInnerClass(name, params);
    }

    public static CodegenExpression relational(CodegenExpression lhs, CodegenExpressionRelational.CodegenRelational op, CodegenExpression rhs) {
        return new CodegenExpressionRelational(lhs, op, rhs);
    }

    public static CodegenExpression newArrayByLength(EPTypeClass component, CodegenExpression expression) {
        return new CodegenExpressionNewArrayByLength(component, expression);
    }

    public static CodegenExpression newArrayWithInit(EPTypeClass component, CodegenExpression ... expressions) {
        return new CodegenExpressionNewArrayWithInit(component, expressions);
    }

    public static void renderExpressions(StringBuilder builder, CodegenExpression[] expressions, Map<Class, String> imports, boolean isInnerClass) {
        String delimiter = "";
        for (CodegenExpression expression : expressions) {
            builder.append(delimiter);
            expression.render(builder, imports, isInnerClass);
            delimiter = ",";
        }
    }

    public static void mergeClassesExpressions(Set<Class> classes, CodegenExpression[] expressions) {
        for (CodegenExpression expression : expressions) {
            expression.mergeClasses(classes);
        }
    }

    public static void traverseMultiple(CodegenExpression[] expressions, Consumer<CodegenExpression> consumer) {
        if (expressions == null) {
            return;
        }
        for (CodegenExpression expression : expressions) {
            consumer.accept(expression);
        }
    }

    public static void traverseMultiple(Collection<CodegenExpression> expressions, Consumer<CodegenExpression> consumer) {
        if (expressions == null) {
            return;
        }
        for (CodegenExpression expression : expressions) {
            consumer.accept(expression);
        }
    }
}

