/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionCastUnderlying
implements CodegenExpression {
    private final EPTypeClass clazz;
    private final String className;
    private final CodegenExpression expression;

    public CodegenExpressionCastUnderlying(EPTypeClass clazz, CodegenExpression expression) {
        this.clazz = clazz;
        this.className = null;
        this.expression = expression;
    }

    public CodegenExpressionCastUnderlying(String className, CodegenExpression expression) {
        this.clazz = null;
        this.className = className;
        this.expression = expression;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("((");
        if (this.clazz != null) {
            CodeGenerationHelper.appendClassName(builder, this.clazz, imports);
        } else {
            CodeGenerationHelper.appendClassName(builder, this.className);
        }
        builder.append(")");
        this.expression.render(builder, imports, isInnerClass);
        builder.append(".").append("getUnderlying())");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        if (this.clazz != null) {
            this.clazz.traverseClasses(classes::add);
        }
        this.expression.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.expression);
    }
}

