/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionConcat
implements CodegenExpression {
    private final CodegenExpression[] stringExpressions;

    public CodegenExpressionConcat(CodegenExpression[] stringExpressions) {
        this.stringExpressions = stringExpressions;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        boolean first = true;
        for (CodegenExpression expression : this.stringExpressions) {
            if (!first) {
                builder.append("+");
            }
            first = false;
            expression.render(builder, imports, isInnerClass);
        }
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        for (CodegenExpression expr : this.stringExpressions) {
            expr.mergeClasses(classes);
        }
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        CodegenExpressionBuilder.traverseMultiple(this.stringExpressions, consumer);
    }
}

