/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionInstanceOf
implements CodegenExpression {
    private final CodegenExpression lhs;
    private final EPTypeClass clazz;
    private final boolean not;

    public CodegenExpressionInstanceOf(CodegenExpression lhs, EPTypeClass clazz, boolean not) {
        this.lhs = lhs;
        this.clazz = clazz;
        this.not = not;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        if (this.not) {
            builder.append("!(");
        }
        this.lhs.render(builder, imports, isInnerClass);
        builder.append(" ").append("instanceof ");
        CodeGenerationHelper.appendClassName(builder, this.clazz, imports);
        if (this.not) {
            builder.append(")");
        }
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.lhs.mergeClasses(classes);
        this.clazz.traverseClasses(classes::add);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.lhs);
    }
}

