/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationHelper;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenClassUtil;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionNewArrayByLength
implements CodegenExpression {
    private final EPTypeClass component;
    private final CodegenExpression expression;

    public CodegenExpressionNewArrayByLength(EPTypeClass component, CodegenExpression expression) {
        this.component = component;
        this.expression = expression;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        int numDimensions = CodegenClassUtil.getNumberOfDimensions(this.component.getType());
        Class outermostType = CodegenClassUtil.getComponentTypeOutermost(this.component.getType());
        builder.append("new ");
        CodeGenerationHelper.appendClassName(builder, outermostType, imports);
        builder.append("[");
        this.expression.render(builder, imports, isInnerClass);
        builder.append("]");
        for (int i = 0; i < numDimensions; ++i) {
            builder.append("[]");
        }
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.component.traverseClasses(classes::add);
        this.expression.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.expression);
    }
}

