/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.expression;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenExpressionOp
implements CodegenExpression {
    private final CodegenExpression left;
    private final String expressionText;
    private final CodegenExpression right;

    public CodegenExpressionOp(CodegenExpression left, String expressionText, CodegenExpression right) {
        this.left = left;
        this.expressionText = expressionText;
        this.right = right;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("(");
        this.left.render(builder, imports, isInnerClass);
        builder.append(this.expressionText);
        this.right.render(builder, imports, isInnerClass);
        builder.append(")");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.left.mergeClasses(classes);
        this.right.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.left);
        consumer.accept(this.right);
    }
}

