/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementAssignArrayElement2Dim
extends CodegenStatementBase {
    private final CodegenExpression array;
    private final CodegenExpression indexOne;
    private final CodegenExpression indexTwo;
    private final CodegenExpression expression;

    public CodegenStatementAssignArrayElement2Dim(CodegenExpression array, CodegenExpression indexOne, CodegenExpression indexTwo, CodegenExpression expression) {
        this.array = array;
        this.indexOne = indexOne;
        this.indexTwo = indexTwo;
        this.expression = expression;
    }

    @Override
    public void renderStatement(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        this.array.render(builder, imports, isInnerClass);
        builder.append("[");
        this.indexOne.render(builder, imports, isInnerClass);
        builder.append("][");
        this.indexTwo.render(builder, imports, isInnerClass);
        builder.append("]=");
        this.expression.render(builder, imports, isInnerClass);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.array.mergeClasses(classes);
        this.indexOne.mergeClasses(classes);
        this.indexTwo.mergeClasses(classes);
        this.expression.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.array);
        consumer.accept(this.indexOne);
        consumer.accept(this.indexTwo);
        consumer.accept(this.expression);
    }
}

