/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionUtil;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementIfConditionReturnConst
extends CodegenStatementBase {
    private final CodegenExpression condition;
    private final Object constant;

    public CodegenStatementIfConditionReturnConst(CodegenExpression condition, Object constant) {
        this.condition = condition;
        this.constant = constant;
    }

    @Override
    public void renderStatement(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass) {
        builder.append("if (");
        this.condition.render(builder, imports, isInnerClass);
        builder.append(") return ");
        CodegenExpressionUtil.renderConstant(builder, this.constant, imports, isInnerClass);
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.condition.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.condition);
    }
}

