/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementSynchronized
extends CodegenStatementWBlockBase {
    private CodegenExpression expression;
    private CodegenBlock block;

    public CodegenStatementSynchronized(CodegenBlock parent, CodegenExpression expression) {
        super(parent);
        this.expression = expression;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        builder.append("synchronized (");
        this.expression.render(builder, imports, isInnerClass);
        builder.append(") {\n");
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}\n");
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.expression.mergeClasses(classes);
        this.block.mergeClasses(classes);
    }

    public CodegenBlock makeBlock() {
        if (this.block != null) {
            throw new IllegalStateException("Block already allocated");
        }
        this.block = new CodegenBlock(this);
        return this.block;
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        consumer.accept(this.expression);
        this.block.traverseExpressions(consumer);
    }
}

