/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.model.statement;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenIndent;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.statement.CodegenStatementWBlockBase;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class CodegenStatementWhileOrDo
extends CodegenStatementWBlockBase {
    private final CodegenExpression condition;
    private final boolean isWhile;
    private CodegenBlock block;

    public CodegenStatementWhileOrDo(CodegenBlock parent, CodegenExpression condition, boolean isWhile) {
        super(parent);
        this.condition = condition;
        this.isWhile = isWhile;
    }

    public void setBlock(CodegenBlock block) {
        this.block = block;
    }

    @Override
    public void render(StringBuilder builder, Map<Class, String> imports, boolean isInnerClass, int level, CodegenIndent indent) {
        if (this.isWhile) {
            builder.append("while (");
            this.condition.render(builder, imports, isInnerClass);
            builder.append(") {\n");
        } else {
            builder.append("do {\n");
        }
        this.block.render(builder, imports, isInnerClass, level + 1, indent);
        indent.indent(builder, level);
        builder.append("}\n");
        if (!this.isWhile) {
            indent.indent(builder, level);
            builder.append("while (");
            this.condition.render(builder, imports, isInnerClass);
            builder.append(");\n");
        }
    }

    @Override
    public void mergeClasses(Set<Class> classes) {
        this.block.mergeClasses(classes);
        this.condition.mergeClasses(classes);
    }

    @Override
    public void traverseExpressions(Consumer<CodegenExpression> consumer) {
        this.block.traverseExpressions(consumer);
        consumer.accept(this.condition);
    }
}

