/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.util;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.ArrayList;
import java.util.List;

public abstract class CodegenRepetitiveBuilderBase {
    protected final CodegenMethod methodNode;
    protected final CodegenClassScope classScope;
    protected final Class provider;
    protected final List<CodegenNamedParam> params = new ArrayList<CodegenNamedParam>(2);

    public abstract void build();

    public CodegenRepetitiveBuilderBase(CodegenMethod methodNode, CodegenClassScope classScope, Class provider) {
        this.methodNode = methodNode;
        this.classScope = classScope;
        this.provider = provider;
    }

    protected static int targetMethodComplexity(CodegenClassScope classScope) {
        return Math.max(1, classScope.getPackageScope().getConfig().getInternalUseOnlyMaxMethodComplexity());
    }

    protected CodegenExpression[] paramNames() {
        CodegenExpression[] names = new CodegenExpression[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            names[i] = CodegenExpressionBuilder.ref(this.params.get(i).getName());
        }
        return names;
    }
}

