/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenRepetitiveBuilderBase;

public class CodegenRepetitiveLengthBuilder
extends CodegenRepetitiveBuilderBase {
    private final int length;
    private ConsumerByLength consumer;

    public CodegenRepetitiveLengthBuilder(int length, CodegenMethod methodNode, CodegenClassScope classScope, Class provider) {
        super(methodNode, classScope, provider);
        this.length = length;
    }

    public CodegenRepetitiveLengthBuilder addParam(EPTypeClass type, String name) {
        this.params.add(new CodegenNamedParam(type, name));
        return this;
    }

    public CodegenRepetitiveLengthBuilder setConsumer(ConsumerByLength consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void build() {
        int complexity = CodegenRepetitiveLengthBuilder.targetMethodComplexity(this.classScope);
        if (this.length < complexity) {
            for (int i = 0; i < this.length; ++i) {
                this.consumer.accept(i, this.methodNode);
            }
            return;
        }
        int count = 0;
        while (count < this.length) {
            int remaining = this.length - count;
            int target = Math.min(remaining, complexity);
            CodegenMethod child = this.methodNode.makeChild(EPTypePremade.VOID.getEPType(), this.provider, (CodegenScope)this.classScope).addParam(this.params);
            this.methodNode.getBlock().localMethod(child, this.paramNames());
            for (int i = 0; i < target; ++i) {
                this.consumer.accept(count, child);
                ++count;
            }
        }
    }

    @FunctionalInterface
    public static interface ConsumerByLength {
        public void accept(int var1, CodegenMethod var2);
    }
}

