/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenRepetitiveBuilderBase;
import java.util.Collection;
import java.util.Iterator;

public class CodegenRepetitiveValueBuilder<V>
extends CodegenRepetitiveBuilderBase {
    private final Collection<V> values;
    private ConsumerByValue<V> consumer;

    public CodegenRepetitiveValueBuilder(Collection<V> values, CodegenMethod methodNode, CodegenClassScope classScope, Class provider) {
        super(methodNode, classScope, provider);
        this.values = values;
    }

    public CodegenRepetitiveValueBuilder<V> addParam(EPTypeClass type, String name) {
        this.params.add(new CodegenNamedParam(type, name));
        return this;
    }

    public CodegenRepetitiveValueBuilder<V> setConsumer(ConsumerByValue<V> consumer) {
        this.consumer = consumer;
        return this;
    }

    @Override
    public void build() {
        int complexity = CodegenRepetitiveValueBuilder.targetMethodComplexity(this.classScope);
        if (this.values.size() < complexity) {
            int index = 0;
            for (V value : this.values) {
                this.consumer.accept(value, index++, this.methodNode);
            }
            return;
        }
        int count = 0;
        Iterator<V> it = this.values.iterator();
        while (count < this.values.size()) {
            int remaining = this.values.size() - count;
            int target = Math.min(remaining, complexity);
            CodegenMethod child = this.methodNode.makeChild(EPTypePremade.VOID.getEPType(), this.provider, (CodegenScope)this.classScope).addParam(this.params);
            this.methodNode.getBlock().localMethod(child, this.paramNames());
            for (int i = 0; i < target; ++i) {
                V value = it.next();
                this.consumer.accept(value, count, child);
                ++count;
            }
        }
    }

    @FunctionalInterface
    public static interface ConsumerByValue<V> {
        public void accept(V var1, int var2, CodegenMethod var3);
    }
}

