/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.bytecodemodel.util;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodFootprint;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenMethodWGraph;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CodegenStackGenerator {
    public static void recursiveBuildStack(CodegenMethod methodNode, String name, CodegenClassMethods methods) {
        if (methodNode.getOptionalSymbolProvider() == null) {
            throw new IllegalArgumentException("Method node does not have symbol provider");
        }
        HashMap<String, EPTypeClass> currentSymbols = new HashMap<String, EPTypeClass>();
        methodNode.getOptionalSymbolProvider().provide(currentSymbols);
        if (!(methodNode instanceof CodegenCtor)) {
            CodegenMethodFootprint footprint = new CodegenMethodFootprint(methodNode.getReturnType(), methodNode.getReturnTypeName(), methodNode.getLocalParams(), methodNode.getAdditionalDebugInfo());
            CodegenMethodWGraph method = new CodegenMethodWGraph(name, footprint, methodNode.getBlock(), true, methodNode.getThrown(), methodNode).setStatic(methodNode.isStatic());
            methodNode.setAssignedMethod(method);
            methods.getPublicMethods().add(method);
        }
        for (CodegenMethod child : methodNode.getChildren()) {
            CodegenStackGenerator.recursiveAdd(child, currentSymbols, methods.getPrivateMethods(), methodNode.isStatic());
        }
    }

    private static void recursiveAdd(CodegenMethod methodNode, Map<String, EPTypeClass> currentSymbols, List<CodegenMethodWGraph> privateMethods, boolean isStatic) {
        TreeSet<String> namesPassed = CodegenStackGenerator.getNamesPassed(methodNode);
        methodNode.setDeepParameters(namesPassed);
        ArrayList<CodegenNamedParam> paramset = new ArrayList<CodegenNamedParam>(namesPassed.size() + methodNode.getLocalParams().size());
        for (CodegenNamedParam named : methodNode.getLocalParams()) {
            paramset.add(named);
        }
        if (methodNode.getOptionalSymbolProvider() == null) {
            for (String name : namesPassed) {
                EPTypeClass symbolType = currentSymbols.get(name);
                if (symbolType == null) {
                    throw new IllegalStateException("Failed to find named parameter '" + name + "' for method from " + methodNode.getAdditionalDebugInfo());
                }
                paramset.add(new CodegenNamedParam(symbolType, name));
            }
        } else {
            currentSymbols = new HashMap<String, EPTypeClass>();
            methodNode.getOptionalSymbolProvider().provide(currentSymbols);
        }
        String name = "m" + privateMethods.size();
        CodegenMethodFootprint footprint = new CodegenMethodFootprint(methodNode.getReturnType(), methodNode.getReturnTypeName(), paramset, methodNode.getAdditionalDebugInfo());
        CodegenMethodWGraph method = new CodegenMethodWGraph(name, footprint, methodNode.getBlock(), false, methodNode.getThrown(), methodNode).setStatic(isStatic);
        methodNode.setAssignedMethod(method);
        privateMethods.add(method);
        for (CodegenMethod child : methodNode.getChildren()) {
            CodegenStackGenerator.recursiveAdd(child, currentSymbols, privateMethods, isStatic);
        }
    }

    private static TreeSet<String> getNamesPassed(CodegenMethod node) {
        TreeSet<String> names = new TreeSet<String>();
        CodegenStackGenerator.recursiveGetNamesPassed(node, names);
        return names;
    }

    private static void recursiveGetNamesPassed(CodegenMethod node, Set<String> names) {
        if (node.getOptionalSymbolProvider() != null) {
            return;
        }
        for (CodegenExpressionRef ref : node.getEnvironment()) {
            names.add(ref.getRef());
        }
        for (CodegenMethod child : node.getChildren()) {
            CodegenStackGenerator.recursiveGetNamesPassed(child, names);
        }
    }
}

