/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyRoot;
import com.espertech.esper.common.internal.collection.IntSeqKeyTwo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeyOne
implements IntSeqKey {
    private int one;

    public IntSeqKeyOne(int one) {
        this.one = one;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 2) {
            return false;
        }
        IntSeqKeyTwo o = (IntSeqKeyTwo)other;
        return this.one == o.getOne();
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyTwo(this.one, num);
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return IntSeqKeyRoot.INSTANCE;
    }

    @Override
    public int length() {
        return 1;
    }

    public int getOne() {
        return this.one;
    }

    @Override
    public int last() {
        return this.one;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyOne that = (IntSeqKeyOne)o;
        return this.one == that.one;
    }

    public int hashCode() {
        return this.one;
    }

    public static void write(IntSeqKeyOne key, DataOutput output) throws IOException {
        output.writeInt(key.one);
    }

    public static IntSeqKeyOne read(DataInput input) throws IOException {
        return new IntSeqKeyOne(input.readInt());
    }
}

