/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyFive;
import com.espertech.esper.common.internal.collection.IntSeqKeyMany;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeySix
implements IntSeqKey {
    private final int one;
    private final int two;
    private final int three;
    private final int four;
    private final int five;
    private final int six;

    public IntSeqKeySix(int one, int two, int three, int four, int five, int six) {
        this.one = one;
        this.two = two;
        this.three = three;
        this.four = four;
        this.five = five;
        this.six = six;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 7) {
            return false;
        }
        IntSeqKeyMany o = (IntSeqKeyMany)other;
        int[] array = o.getArray();
        return this.one == array[0] && this.two == array[1] && this.three == array[2] && this.four == array[3] && this.five == array[4] && this.six == array[5];
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyMany(new int[]{this.one, this.two, this.three, this.four, this.five, this.six, num});
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return new IntSeqKeyFive(this.one, this.two, this.three, this.four, this.five);
    }

    @Override
    public int length() {
        return 6;
    }

    @Override
    public int last() {
        return this.six;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one, this.two, this.three, this.four, this.five, this.six};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeySix that = (IntSeqKeySix)o;
        if (this.one != that.one) {
            return false;
        }
        if (this.two != that.two) {
            return false;
        }
        if (this.three != that.three) {
            return false;
        }
        if (this.four != that.four) {
            return false;
        }
        if (this.five != that.five) {
            return false;
        }
        return this.six == that.six;
    }

    public int hashCode() {
        int result = this.one;
        result = 31 * result + this.two;
        result = 31 * result + this.three;
        result = 31 * result + this.four;
        result = 31 * result + this.five;
        result = 31 * result + this.six;
        return result;
    }

    public int getOne() {
        return this.one;
    }

    public int getTwo() {
        return this.two;
    }

    public int getThree() {
        return this.three;
    }

    public int getFour() {
        return this.four;
    }

    public int getFive() {
        return this.five;
    }

    public int getSix() {
        return this.six;
    }

    public static void write(IntSeqKeySix key, DataOutput output) throws IOException {
        output.writeInt(key.one);
        output.writeInt(key.two);
        output.writeInt(key.three);
        output.writeInt(key.four);
        output.writeInt(key.five);
        output.writeInt(key.six);
    }

    public static IntSeqKeySix read(DataInput input) throws IOException {
        return new IntSeqKeySix(input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt(), input.readInt());
    }
}

