/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyFour;
import com.espertech.esper.common.internal.collection.IntSeqKeyTwo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeyThree
implements IntSeqKey {
    private final int one;
    private final int two;
    private final int three;

    public IntSeqKeyThree(int one, int two, int three) {
        this.one = one;
        this.two = two;
        this.three = three;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 4) {
            return false;
        }
        IntSeqKeyFour o = (IntSeqKeyFour)other;
        return this.one == o.getOne() && this.two == o.getTwo() && this.three == o.getThree();
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyFour(this.one, this.two, this.three, num);
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return new IntSeqKeyTwo(this.one, this.two);
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public int last() {
        return this.three;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one, this.two, this.three};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyThree that = (IntSeqKeyThree)o;
        if (this.one != that.one) {
            return false;
        }
        if (this.two != that.two) {
            return false;
        }
        return this.three == that.three;
    }

    public int hashCode() {
        int result = this.one;
        result = 31 * result + this.two;
        result = 31 * result + this.three;
        return result;
    }

    public int getOne() {
        return this.one;
    }

    public int getTwo() {
        return this.two;
    }

    public int getThree() {
        return this.three;
    }

    public static void write(IntSeqKeyThree key, DataOutput output) throws IOException {
        output.writeInt(key.one);
        output.writeInt(key.two);
        output.writeInt(key.three);
    }

    public static IntSeqKeyThree read(DataInput input) throws IOException {
        return new IntSeqKeyThree(input.readInt(), input.readInt(), input.readInt());
    }
}

