/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.collection.IntSeqKeyOne;
import com.espertech.esper.common.internal.collection.IntSeqKeyThree;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IntSeqKeyTwo
implements IntSeqKey {
    private final int one;
    private final int two;

    public IntSeqKeyTwo(int one, int two) {
        this.one = one;
        this.two = two;
    }

    @Override
    public boolean isParentTo(IntSeqKey other) {
        if (other.length() != 3) {
            return false;
        }
        IntSeqKeyThree o = (IntSeqKeyThree)other;
        return this.one == o.getOne() && this.two == o.getTwo();
    }

    @Override
    public IntSeqKey addToEnd(int num) {
        return new IntSeqKeyThree(this.one, this.two, num);
    }

    @Override
    public IntSeqKey removeFromEnd() {
        return new IntSeqKeyOne(this.one);
    }

    @Override
    public int length() {
        return 2;
    }

    @Override
    public int last() {
        return this.two;
    }

    @Override
    public int[] asIntArray() {
        return new int[]{this.one, this.two};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSeqKeyTwo that = (IntSeqKeyTwo)o;
        if (this.one != that.one) {
            return false;
        }
        return this.two == that.two;
    }

    public int hashCode() {
        int result = this.one;
        result = 31 * result + this.two;
        return result;
    }

    public int getOne() {
        return this.one;
    }

    public int getTwo() {
        return this.two;
    }

    public static void write(IntSeqKeyTwo key, DataOutput output) throws IOException {
        output.writeInt(key.one);
        output.writeInt(key.two);
    }

    public static IntSeqKeyTwo read(DataInput input) throws IOException {
        return new IntSeqKeyTwo(input.readInt(), input.readInt());
    }
}

