/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.client.EventBean;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class MixedEventBeanAndCollectionIteratorBase
implements Iterator<EventBean> {
    private final Iterator keyIterator;
    private Iterator<EventBean> currentListIterator;
    private EventBean currentItem;

    protected abstract Object getValue(Object var1);

    protected MixedEventBeanAndCollectionIteratorBase(Iterator keyIterator) {
        this.keyIterator = keyIterator;
    }

    protected void init() {
        if (this.keyIterator.hasNext()) {
            this.goToNext();
        }
    }

    @Override
    public final EventBean next() {
        EventBean eventBean;
        if (this.currentListIterator == null && this.currentItem == null) {
            throw new NoSuchElementException();
        }
        if (this.currentListIterator != null) {
            eventBean = this.currentListIterator.next();
            if (!this.currentListIterator.hasNext()) {
                this.currentListIterator = null;
                this.currentItem = null;
                if (this.keyIterator.hasNext()) {
                    this.goToNext();
                }
            }
        } else {
            eventBean = this.currentItem;
            this.currentItem = null;
            if (this.keyIterator.hasNext()) {
                this.goToNext();
            }
        }
        return eventBean;
    }

    @Override
    public final boolean hasNext() {
        if (this.currentListIterator == null && this.currentItem == null) {
            return false;
        }
        if (this.currentItem != null) {
            return true;
        }
        if (this.currentListIterator.hasNext()) {
            return true;
        }
        this.currentListIterator = null;
        this.currentItem = null;
        return this.keyIterator.hasNext();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private void goToNext() {
        Object nextKey = this.keyIterator.next();
        Object entry = this.getValue(nextKey);
        while (true) {
            if (entry instanceof Collection) {
                this.currentListIterator = ((Collection)entry).iterator();
                if (this.currentListIterator.hasNext()) break;
                this.currentListIterator = null;
            } else if (entry instanceof EventBean) {
                this.currentItem = (EventBean)entry;
                break;
            }
            if (!this.keyIterator.hasNext()) break;
            nextKey = this.keyIterator.next();
            entry = this.getValue(nextKey);
        }
    }
}

