/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.internal.collection.Pair;
import java.util.HashMap;
import java.util.Map;

public class RefCountedMap<K, V> {
    private Map<K, Pair<V, Integer>> refMap = new HashMap<K, Pair<V, Integer>>();

    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Collection does not allow null key values");
        }
        if (this.refMap.containsKey(key)) {
            throw new IllegalStateException("Key value already in collection");
        }
        Pair<V, Integer> refValue = new Pair<V, Integer>(value, 1);
        this.refMap.put(key, refValue);
        return value;
    }

    public V get(K key) {
        Pair<V, Integer> refValue = this.refMap.get(key);
        if (refValue == null) {
            return null;
        }
        return refValue.getFirst();
    }

    public void reference(K key) {
        Pair<V, Integer> refValue = this.refMap.get(key);
        if (refValue == null) {
            throw new IllegalStateException("Key value not found in collection");
        }
        refValue.setSecond(refValue.getSecond() + 1);
    }

    public boolean dereference(K key) {
        Pair<V, Integer> refValue = this.refMap.get(key);
        if (refValue == null) {
            throw new IllegalStateException("Key value not found in collection");
        }
        int refCounter = refValue.getSecond();
        if (refCounter < 1) {
            throw new IllegalStateException("Unexpected reference counter value " + refValue.getSecond() + " encountered for key " + key);
        }
        if (refCounter == 1) {
            this.refMap.remove(key);
            return true;
        }
        refValue.setSecond(refCounter - 1);
        return false;
    }

    public void clear() {
        this.refMap.clear();
    }
}

