/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.collection;

import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class SortedDoubleVector {
    public static final EPTypeClass EPTYPE = new EPTypeClass(SortedDoubleVector.class);
    private ArrayList<Double> values;

    public SortedDoubleVector() {
        this.values = new ArrayList();
    }

    public SortedDoubleVector(ArrayList<Double> values) {
        this.values = values;
    }

    public void clear() {
        this.values.clear();
    }

    public int size() {
        return this.values.size();
    }

    public double getValue(int index) {
        return this.values.get(index);
    }

    public void add(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        int index = this.findInsertIndex(value);
        if (index == -1) {
            this.values.add(value);
        } else {
            this.values.add(index, value);
        }
    }

    public void remove(double value) {
        if (Double.isNaN(value)) {
            return;
        }
        int index = this.findInsertIndex(value);
        if (index == -1) {
            return;
        }
        Double valueAtIndex = this.values.get(index);
        if (valueAtIndex != null && !valueAtIndex.equals(value)) {
            return;
        }
        this.values.remove(index);
    }

    public ArrayList<Double> getValues() {
        return this.values;
    }

    protected int findInsertIndex(double value) {
        if (this.values.size() > 2) {
            int startIndex = this.values.size() >> 1;
            double startValue = this.values.get(startIndex);
            int insertAt = value < startValue ? this.findInsertIndex(0, startIndex - 1, value) : (value > startValue ? this.findInsertIndex(startIndex + 1, this.values.size() - 1, value) : startIndex);
            if (insertAt == this.values.size()) {
                return -1;
            }
            return insertAt;
        }
        if (this.values.size() == 2) {
            if (value > this.values.get(1)) {
                return -1;
            }
            if (value <= this.values.get(0)) {
                return 0;
            }
            return 1;
        }
        if (this.values.size() == 1) {
            if (value > this.values.get(0)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private int findInsertIndex(int lowerBound, int upperBound, double value) {
        int nextMiddle;
        while (true) {
            if (upperBound == lowerBound) {
                double valueLowerBound = this.values.get(lowerBound);
                if (value <= valueLowerBound) {
                    return lowerBound;
                }
                return lowerBound + 1;
            }
            if (upperBound - lowerBound == 1) {
                double valueLowerBound = this.values.get(lowerBound);
                if (value <= valueLowerBound) {
                    return lowerBound;
                }
                double valueUpperBound = this.values.get(upperBound);
                if (value > valueUpperBound) {
                    return upperBound + 1;
                }
                return upperBound;
            }
            nextMiddle = lowerBound + (upperBound - lowerBound >> 1);
            double valueAtMiddle = this.values.get(nextMiddle);
            if (value < valueAtMiddle) {
                upperBound = nextMiddle - 1;
                continue;
            }
            if (!(value > valueAtMiddle)) break;
            lowerBound = nextMiddle;
        }
        return nextMiddle;
    }

    public static void writePoints(DataOutput output, SortedDoubleVector vector) throws IOException {
        output.writeInt(vector.getValues().size());
        for (double num : vector.getValues()) {
            output.writeDouble(num);
        }
    }

    public static SortedDoubleVector readPoints(DataInput input) throws IOException {
        SortedDoubleVector points = new SortedDoubleVector();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            double d = input.readDouble();
            points.add(d);
        }
        return points;
    }
}

