/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRefVisitor;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import java.util.Arrays;

public class MultiKeyClassRefUUIDBased
implements MultiKeyClassRef {
    private final String uuid = CodeGenerationIDGenerator.generateClassNameUUID();
    private final EPType[] mkTypes;
    private final DataInputOutputSerdeForge[] serdes;
    private String classPostfix;

    public MultiKeyClassRefUUIDBased(EPType[] mkTypes, DataInputOutputSerdeForge[] serdes) {
        this.mkTypes = mkTypes;
        this.serdes = serdes;
    }

    public String getClassNameMK(String classPostfix) {
        this.assignPostfix(classPostfix);
        return CodeGenerationIDGenerator.generateClassNameWithUUID(HashableMultiKey.class, classPostfix, this.uuid);
    }

    @Override
    public String getClassNameMK() {
        this.checkClassPostfix();
        return this.getClassNameMK(this.classPostfix);
    }

    public String getClassNameMKSerde(String classPostfix) {
        return CodeGenerationIDGenerator.generateClassNameWithUUID(DataInputOutputSerde.class, classPostfix, this.uuid);
    }

    @Override
    public CodegenExpression getExprMKSerde(CodegenMethod method, CodegenClassScope classScope) {
        this.checkClassPostfix();
        return CodegenExpressionBuilder.newInstance(this.getClassNameMKSerde(this.classPostfix), new CodegenExpression[0]);
    }

    @Override
    public EPType[] getMKTypes() {
        return this.mkTypes;
    }

    public DataInputOutputSerdeForge[] getSerdes() {
        return this.serdes;
    }

    public String toString() {
        return "MultiKeyClassRefUUIDBased{uuid='" + this.uuid + "', mkTypes=" + Arrays.toString(this.mkTypes) + ", classPostfix='" + this.classPostfix + "'}";
    }

    @Override
    public DataInputOutputSerdeForge[] getSerdeForges() {
        return this.serdes;
    }

    @Override
    public <T> T accept(MultiKeyClassRefVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private void checkClassPostfix() {
        if (this.classPostfix == null) {
            throw new IllegalArgumentException("Class postfix has not been assigned");
        }
    }

    private void assignPostfix(String classPostfix) {
        if (this.classPostfix == null) {
            this.classPostfix = classPostfix;
            return;
        }
        if (!this.classPostfix.equals(classPostfix)) {
            throw new IllegalArgumentException("Invalid class postfix");
        }
    }
}

