/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.MultiKey;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.collection.MultiKeyFromMultiKey;
import com.espertech.esper.common.internal.collection.MultiKeyFromObjectArray;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.multikey.StmtClassForgeableMultiKey;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class MultiKeyCodegen {
    public static CodegenExpressionNewAnonymousClass codegenEvaluatorReturnObjectOrArray(ExprForge[] forges, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        return MultiKeyCodegen.codegenEvaluatorReturnObjectOrArrayWCoerce(forges, null, false, method, generator, classScope);
    }

    public static CodegenExpressionNewAnonymousClass codegenEvaluatorReturnObjectOrArrayWCoerce(ExprForge[] forges, EPType[] targetTypes, boolean arrayMultikeyWhenSingleEvaluator, CodegenMethod method, Class generator, CodegenClassScope classScope) {
        int i;
        CodegenExpressionNewAnonymousClass evaluator = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEvaluator.EPTYPE);
        CodegenMethod evaluate = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), generator, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        evaluator.addMethod("evaluate", evaluate);
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = evaluate.makeChildWithScope(EPTypePremade.OBJECT.getEPType(), CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression[] expressions = new CodegenExpression[forges.length];
        for (i = 0; i < forges.length; ++i) {
            EPType type = forges[i].getEvaluationType();
            expressions[i] = type == null || type == EPTypeNull.INSTANCE ? CodegenExpressionBuilder.constantNull() : forges[i].evaluateCodegen((EPTypeClass)type, exprMethod, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(evaluate, exprMethod.getBlock(), classScope);
        if (forges.length == 0) {
            exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        } else if (forges.length == 1) {
            EPType evaluationType = forges[0].getEvaluationType();
            if (evaluationType != EPTypeNull.INSTANCE && arrayMultikeyWhenSingleEvaluator && ((EPTypeClass)evaluationType).getType().isArray()) {
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType((EPTypeClass)evaluationType);
                EPTypeClass clazz = MultiKeyPlanner.getMKClassForComponentType(componentType);
                coerced = CodegenExpressionBuilder.newInstance(clazz, expressions[0]);
            } else {
                coerced = ExprNodeUtilityCodegen.codegenCoerce(expressions[0], evaluationType, targetTypes == null ? null : targetTypes[0], false);
            }
            exprMethod.getBlock().methodReturn(coerced);
        } else {
            exprMethod.getBlock().declareVar(EPTypePremade.OBJECTARRAY.getEPType(), "values", CodegenExpressionBuilder.newArrayByLength(EPTypePremade.OBJECT.getEPType(), CodegenExpressionBuilder.constant(forges.length)));
            for (i = 0; i < forges.length; ++i) {
                coerced = ExprNodeUtilityCodegen.codegenCoerce(expressions[i], forges[i].getEvaluationType(), targetTypes == null ? null : targetTypes[i], false);
                exprMethod.getBlock().assignArrayElement("values", CodegenExpressionBuilder.constant(i), coerced);
            }
            exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.ref("values"));
        }
        evaluate.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        return evaluator;
    }

    public static CodegenExpression codegenExprEvaluatorMayMultikey(ExprNode[] expressionNodes, EPTypeClass[] optionalCoercionTypes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        if (expressionNodes == null || expressionNodes.length == 0) {
            return CodegenExpressionBuilder.constantNull();
        }
        return MultiKeyCodegen.codegenExprEvaluatorMayMultikey(ExprNodeUtilityQuery.getForges(expressionNodes), optionalCoercionTypes, multiKeyClassRef, method, classScope);
    }

    public static CodegenExpression codegenExprEvaluatorMayMultikey(ExprForge[] forges, EPTypeClass[] optionalCoercionTypes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        if (forges == null || forges.length == 0) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (multiKeyClassRef != null && multiKeyClassRef.getClassNameMK() != null) {
            return MultiKeyCodegen.codegenMultiKeyExprEvaluator(forges, multiKeyClassRef, method, classScope);
        }
        return ExprNodeUtilityCodegen.codegenEvaluatorWCoerce(forges[0], optionalCoercionTypes == null ? null : optionalCoercionTypes[0], method, MultiKeyCodegen.class, classScope);
    }

    public static CodegenMethod codegenMethod(ExprNode[] expressionNodes, MultiKeyClassRef multiKeyClassRef, CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod eventUnpackMethod = parent.makeChildWithScope(EPTypePremade.OBJECT.getEPType(), CodegenLegoMethodExpression.class, CodegenSymbolProviderEmpty.INSTANCE, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = eventUnpackMethod.makeChildWithScope(EPTypePremade.OBJECT.getEPType(), CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression[] expressions = new CodegenExpression[expressionNodes.length];
        for (int i = 0; i < expressionNodes.length; ++i) {
            ExprForge forge = expressionNodes[i].getForge();
            EPType type = multiKeyClassRef.getMKTypes()[i];
            expressions[i] = ExprNodeUtilityCodegen.codegenExpressionMayCoerce(forge, type, exprMethod, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(eventUnpackMethod, exprMethod.getBlock(), classScope);
        exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(multiKeyClassRef.getClassNameMK(), expressions));
        eventUnpackMethod.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        return eventUnpackMethod;
    }

    public static CodegenExpression codegenGetterMayMultiKey(EventType eventType, EventPropertyGetterSPI[] getters, EPType[] getterResultTypes, EPTypeClass[] optionalCoercionTypes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        if (getters == null || getters.length == 0) {
            return CodegenExpressionBuilder.constantNull();
        }
        if (multiKeyClassRef != null && multiKeyClassRef.getClassNameMK() != null) {
            return MultiKeyCodegen.codegenMultiKeyGetter(eventType, getters, getterResultTypes, multiKeyClassRef, method, classScope);
        }
        return EventTypeUtility.codegenGetterWCoerce(getters[0], getterResultTypes[0], optionalCoercionTypes == null ? null : optionalCoercionTypes[0], method, MultiKeyCodegen.class, classScope);
    }

    public static CodegenExpression codegenMultiKeyFromArrayTransform(MultiKeyClassRef optionalMultiKeyClasses, CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass fromClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), MultiKeyFromObjectArray.EPTYPE);
        CodegenMethod from = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), MultiKeyCodegen.class, classScope).addParam(EPTypePremade.OBJECTARRAY.getEPType(), "keys");
        fromClass.addMethod("from", from);
        if (optionalMultiKeyClasses == null || optionalMultiKeyClasses.getClassNameMK() == null) {
            from.getBlock().methodReturn(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("keys"), CodegenExpressionBuilder.constant(0)));
        } else if (optionalMultiKeyClasses.getMKTypes().length == 1) {
            EPType paramType = optionalMultiKeyClasses.getMKTypes()[0];
            if (paramType == null || paramType == EPTypeNull.INSTANCE || !((EPTypeClass)paramType).getType().isArray()) {
                from.getBlock().methodReturn(CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("keys"), CodegenExpressionBuilder.constant(0)));
            } else {
                EPTypeClass paramTypeClass = (EPTypeClass)paramType;
                EPTypeClass componentType = JavaClassHelper.getArrayComponentType(paramTypeClass);
                EPTypeClass mktype = MultiKeyPlanner.getMKClassForComponentType(componentType);
                from.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(mktype, CodegenExpressionBuilder.cast(paramTypeClass, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("keys"), CodegenExpressionBuilder.constant(0)))));
            }
        } else {
            CodegenExpression[] expressions = new CodegenExpression[optionalMultiKeyClasses.getMKTypes().length];
            for (int i = 0; i < expressions.length; ++i) {
                EPType type = optionalMultiKeyClasses.getMKTypes()[i];
                expressions[i] = type == EPTypeNull.INSTANCE ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.cast((EPTypeClass)type, CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("keys"), CodegenExpressionBuilder.constant(i)));
            }
            from.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(optionalMultiKeyClasses.getClassNameMK(), expressions));
        }
        return fromClass;
    }

    public static CodegenExpression codegenMultiKeyFromMultiKeyTransform(MultiKeyClassRef optionalMultiKeyClasses, CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass fromClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), MultiKeyFromMultiKey.EPTYPE);
        CodegenMethod from = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), MultiKeyCodegen.class, classScope).addParam(EPTypePremade.OBJECT.getEPType(), "key");
        fromClass.addMethod("from", from);
        if (optionalMultiKeyClasses == null || optionalMultiKeyClasses.getClassNameMK() == null || optionalMultiKeyClasses.getMKTypes().length == 1) {
            from.getBlock().methodReturn(CodegenExpressionBuilder.ref("key"));
        } else {
            CodegenExpression[] expressions = new CodegenExpression[optionalMultiKeyClasses.getMKTypes().length];
            from.getBlock().declareVar(MultiKey.EPTYPE, "mk", CodegenExpressionBuilder.cast(MultiKey.EPTYPE, (CodegenExpression)CodegenExpressionBuilder.ref("key")));
            for (int i = 0; i < expressions.length; ++i) {
                EPType type = optionalMultiKeyClasses.getMKTypes()[i];
                expressions[i] = type == EPTypeNull.INSTANCE ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.cast((EPTypeClass)type, CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("mk"), "getKey", CodegenExpressionBuilder.constant(i)));
            }
            from.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(optionalMultiKeyClasses.getClassNameMK(), expressions));
        }
        return fromClass;
    }

    public static CodegenExpression codegenGetterEventDistinct(boolean isDistinct, EventType eventType, MultiKeyClassRef optionalDistinctMultiKey, CodegenMethod method, CodegenClassScope classScope) {
        if (!isDistinct) {
            return CodegenExpressionBuilder.constantNull();
        }
        String[] propertyNames = eventType.getPropertyNames();
        EventTypeSPI spi = (EventTypeSPI)eventType;
        if (propertyNames.length == 1) {
            String propertyName = propertyNames[0];
            EPType result = eventType.getPropertyEPType(propertyName);
            EventPropertyGetterSPI getter = spi.getGetterSPI(propertyName);
            return EventTypeUtility.codegenGetterWCoerceWArray(EventPropertyValueGetter.EPTYPE, getter, result, null, method, MultiKeyCodegen.class, classScope);
        }
        EventPropertyGetterSPI[] getters = new EventPropertyGetterSPI[propertyNames.length];
        EPType[] getterResultTypes = new EPType[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            getterResultTypes[i] = eventType.getPropertyEPType(propertyNames[i]);
            getters[i] = spi.getGetterSPI(propertyNames[i]);
        }
        if (eventType instanceof VariantEventType) {
            return MultiKeyCodegen.codegenMultikeyGetterBeanGet(getters, getterResultTypes, optionalDistinctMultiKey, method, classScope);
        }
        return MultiKeyCodegen.codegenGetterMayMultiKey(eventType, getters, getterResultTypes, null, optionalDistinctMultiKey, method, classScope);
    }

    private static CodegenExpression codegenMultiKeyExprEvaluator(ExprForge[] expressionNodes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass evaluator = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), ExprEvaluator.EPTYPE);
        CodegenMethod evaluate = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableMultiKey.class, classScope).addParam(ExprForgeCodegenNames.PARAMS);
        evaluator.addMethod("evaluate", evaluate);
        ExprForgeCodegenSymbol exprSymbol = new ExprForgeCodegenSymbol(true, null);
        CodegenMethod exprMethod = evaluate.makeChildWithScope(EPTypePremade.OBJECT.getEPType(), CodegenLegoMethodExpression.class, (CodegenSymbolProvider)exprSymbol, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenExpression[] expressions = new CodegenExpression[expressionNodes.length];
        for (int i = 0; i < expressionNodes.length; ++i) {
            expressions[i] = ExprNodeUtilityCodegen.codegenExpressionMayCoerce(expressionNodes[i], multiKeyClassRef.getMKTypes()[i], exprMethod, exprSymbol, classScope);
        }
        exprSymbol.derivedSymbolsCodegen(evaluate, exprMethod.getBlock(), classScope);
        exprMethod.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(multiKeyClassRef.getClassNameMK(), expressions));
        evaluate.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(exprMethod, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        return evaluator;
    }

    private static CodegenExpression codegenMultiKeyGetter(EventType eventType, EventPropertyGetterSPI[] getters, EPType[] getterResultTypes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        CodegenMethod get = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableMultiKey.class, classScope).addParam(EventBean.EPTYPE, "bean");
        CodegenExpressionNewAnonymousClass getter = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyValueGetter.EPTYPE);
        getter.addMethod("get", get);
        CodegenExpression[] expressions = new CodegenExpression[getters.length];
        for (int i = 0; i < getters.length; ++i) {
            expressions[i] = getters[i].underlyingGetCodegen(CodegenExpressionBuilder.ref("und"), get, classScope);
            EPType mkType = multiKeyClassRef.getMKTypes()[i];
            EPType getterType = getterResultTypes[i];
            expressions[i] = ExprNodeUtilityCodegen.codegenCoerce(expressions[i], getterType, mkType, true);
        }
        get.getBlock().declareVar(eventType.getUnderlyingEPType(), "und", CodegenExpressionBuilder.cast(eventType.getUnderlyingEPType(), CodegenExpressionBuilder.exprDotUnderlying(CodegenExpressionBuilder.ref("bean")))).methodReturn(CodegenExpressionBuilder.newInstance(multiKeyClassRef.getClassNameMK(), expressions));
        return getter;
    }

    private static CodegenExpression codegenMultikeyGetterBeanGet(EventPropertyGetterSPI[] getters, EPType[] getterResultTypes, MultiKeyClassRef multiKeyClassRef, CodegenMethod method, CodegenClassScope classScope) {
        CodegenMethod get = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableMultiKey.class, classScope).addParam(EventBean.EPTYPE, "bean");
        CodegenExpressionNewAnonymousClass getter = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), EventPropertyValueGetter.EPTYPE);
        getter.addMethod("get", get);
        CodegenExpression[] expressions = new CodegenExpression[getters.length];
        for (int i = 0; i < getters.length; ++i) {
            expressions[i] = getters[i].eventBeanGetCodegen(CodegenExpressionBuilder.ref("bean"), get, classScope);
            EPType mkType = multiKeyClassRef.getMKTypes()[i];
            EPType getterType = getterResultTypes[i];
            expressions[i] = ExprNodeUtilityCodegen.codegenCoerce(expressions[i], getterType, mkType, true);
        }
        get.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(multiKeyClassRef.getClassNameMK(), expressions));
        return getter;
    }
}

