/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassType;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableType;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collections;

public class StmtClassForgeableMultiKeySerde
implements StmtClassForgeable {
    private static final String OBJECT_NAME = "obj";
    private static final String OUTPUT_NAME = "output";
    private static final String INPUT_NAME = "input";
    private static final String UNITKEY_NAME = "unitKey";
    private static final String WRITER_NAME = "writer";
    private final String className;
    private final CodegenPackageScope packageScope;
    private final EPType[] types;
    private final String classNameMK;
    private final DataInputOutputSerdeForge[] forges;

    public StmtClassForgeableMultiKeySerde(String className, CodegenPackageScope packageScope, EPType[] types, String classNameMK, DataInputOutputSerdeForge[] forges) {
        this.className = className;
        this.packageScope = packageScope;
        this.types = types;
        this.classNameMK = classNameMK;
        this.forges = forges;
    }

    @Override
    public CodegenClass forge(boolean includeDebugSymbols, boolean fireAndForget) {
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenClassScope classScope = new CodegenClassScope(includeDebugSymbols, this.packageScope, this.className);
        CodegenMethod writeMethod = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), StmtClassForgeableMultiKeySerde.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.OBJECT.getEPType(), OBJECT_NAME).addParam(EPTypePremade.DATAOUTPUT.getEPType(), OUTPUT_NAME).addParam(EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNITKEY_NAME).addParam(EventBeanCollatedWriter.EPTYPE, WRITER_NAME).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
        if (!fireAndForget) {
            this.makeWriteMethod(writeMethod);
        }
        CodegenStackGenerator.recursiveBuildStack(writeMethod, "write", methods);
        CodegenMethod readMethod = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), StmtClassForgeableMultiKeySerde.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.DATAINPUT.getEPType(), INPUT_NAME).addParam(EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), UNITKEY_NAME).addThrown(EPTypePremade.IOEXCEPTION.getEPType());
        if (!fireAndForget) {
            this.makeReadMethod(readMethod);
        } else {
            readMethod.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        }
        CodegenStackGenerator.recursiveBuildStack(readMethod, "read", methods);
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>();
        for (int i = 0; i < this.forges.length; ++i) {
            members.add(new CodegenTypedParam(this.forges[i].forgeClassName(), "s" + i));
        }
        CodegenCtor providerCtor = new CodegenCtor(this.getClass(), includeDebugSymbols, Collections.emptyList());
        for (int i = 0; i < this.forges.length; ++i) {
            providerCtor.getBlock().assignRef("s" + i, this.forges[i].codegen(providerCtor, classScope, null));
        }
        return new CodegenClass(CodegenClassType.KEYPROVISIONINGSERDE, DataInputOutputSerde.EPTYPE, this.className, classScope, members, providerCtor, methods, Collections.emptyList());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public StmtClassForgeableType getForgeableType() {
        return StmtClassForgeableType.MULTIKEY;
    }

    private void makeWriteMethod(CodegenMethod writeMethod) {
        writeMethod.getBlock().declareVar(this.classNameMK, "key", CodegenExpressionBuilder.cast(this.classNameMK, (CodegenExpression)CodegenExpressionBuilder.ref(OBJECT_NAME)));
        for (int i = 0; i < this.types.length; ++i) {
            CodegenExpressionRef key = CodegenExpressionBuilder.ref("key.k" + i);
            CodegenExpressionRef serde = CodegenExpressionBuilder.ref("s" + i);
            writeMethod.getBlock().exprDotMethod(serde, "write", key, CodegenExpressionBuilder.ref(OUTPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME), CodegenExpressionBuilder.ref(WRITER_NAME));
        }
    }

    private void makeReadMethod(CodegenMethod readMethod) {
        CodegenExpression[] params = new CodegenExpression[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            CodegenExpressionRef serde = CodegenExpressionBuilder.ref("s" + i);
            EPType boxed = JavaClassHelper.getBoxedType(this.types[i]);
            CodegenExpression read = CodegenExpressionBuilder.exprDotMethod(serde, "read", CodegenExpressionBuilder.ref(INPUT_NAME), CodegenExpressionBuilder.ref(UNITKEY_NAME));
            params[i] = boxed != EPTypeNull.INSTANCE ? CodegenExpressionBuilder.cast((EPTypeClass)boxed, read) : read;
        }
        readMethod.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(this.classNameMK, params));
    }
}

