/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage1.spec;

import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class InsertIntoDesc
implements Serializable {
    private final SelectClauseStreamSelectorEnum streamSelector;
    private final String eventTypeName;
    private List<String> columnNames;
    private ExprNode eventPrecedence;
    private static final long serialVersionUID = 6204369134039715720L;

    public InsertIntoDesc(SelectClauseStreamSelectorEnum streamSelector, String eventTypeName) {
        this.streamSelector = streamSelector;
        this.eventTypeName = eventTypeName;
        this.columnNames = new LinkedList<String>();
    }

    public SelectClauseStreamSelectorEnum getStreamSelector() {
        return this.streamSelector;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void add(String columnName) {
        this.columnNames.add(columnName);
    }

    public ExprNode getEventPrecedence() {
        return this.eventPrecedence;
    }

    public void setEventPrecedence(ExprNode eventPrecedence) {
        this.eventPrecedence = eventPrecedence;
    }

    public static InsertIntoDesc fromColumns(String streamName, List<String> columns) {
        InsertIntoDesc insertIntoDesc = new InsertIntoDesc(SelectClauseStreamSelectorEnum.ISTREAM_ONLY, streamName);
        for (String col : columns) {
            insertIntoDesc.add(col);
        }
        return insertIntoDesc;
    }
}

