/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage1.spec;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInPatternObject;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInView;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInVirtualDataWindow;
import com.espertech.esper.common.client.util.PatternObjectType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectEntry;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectType;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PluggableObjectCollection {
    private Map<String, Map<String, Pair<Class, PluggableObjectEntry>>> pluggables = new HashMap<String, Map<String, Pair<Class, PluggableObjectEntry>>>();

    public void addViews(List<ConfigurationCompilerPlugInView> configurationPlugInViews, List<ConfigurationCompilerPlugInVirtualDataWindow> configurationPlugInVirtualDW, ClasspathImportServiceCompileTime classpathImportService) throws ConfigurationException {
        this.initViews(configurationPlugInViews, classpathImportService);
        this.initVirtualDW(configurationPlugInVirtualDW, classpathImportService);
    }

    public void addPatternObjects(List<ConfigurationCompilerPlugInPatternObject> configPattern, ClasspathImportServiceCompileTime classpathImportService) throws ConfigurationException {
        this.initPatterns(configPattern, classpathImportService);
    }

    public void addObjects(PluggableObjectCollection other) {
        for (Map.Entry<String, Map<String, Pair<Class, PluggableObjectEntry>>> entry : other.getPluggables().entrySet()) {
            Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(entry.getKey());
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
                this.pluggables.put(entry.getKey(), namespaceMap);
            }
            for (String name : entry.getValue().keySet()) {
                if (!namespaceMap.containsKey(name)) continue;
                throw new ConfigurationException("Duplicate object detected in namespace '" + entry.getKey() + "' by name '" + name + "'");
            }
            namespaceMap.putAll(entry.getValue());
        }
    }

    public void addObject(String namespace, String name, Class clazz, PluggableObjectType type) {
        this.addObject(namespace, name, clazz, type, null);
    }

    public void addObject(String namespace, String name, Class clazz, PluggableObjectType type, Serializable configuration) {
        Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(namespace);
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
            this.pluggables.put(namespace, namespaceMap);
        }
        namespaceMap.put(name, new Pair<Class, PluggableObjectEntry>(clazz, new PluggableObjectEntry(type, configuration)));
    }

    public Map<String, Map<String, Pair<Class, PluggableObjectEntry>>> getPluggables() {
        return this.pluggables;
    }

    private void initViews(List<ConfigurationCompilerPlugInView> configurationPlugInViews, ClasspathImportServiceCompileTime classpathImportService) {
        if (configurationPlugInViews == null) {
            return;
        }
        for (ConfigurationCompilerPlugInView entry : configurationPlugInViews) {
            this.handleAddPluggableObject(entry.getForgeClassName(), entry.getNamespace(), entry.getName(), PluggableObjectType.VIEW, null, classpathImportService);
        }
    }

    private void initVirtualDW(List<ConfigurationCompilerPlugInVirtualDataWindow> configurationPlugInVirtualDataWindows, ClasspathImportServiceCompileTime classpathImportService) {
        if (configurationPlugInVirtualDataWindows == null) {
            return;
        }
        for (ConfigurationCompilerPlugInVirtualDataWindow entry : configurationPlugInVirtualDataWindows) {
            this.handleAddPluggableObject(entry.getForgeClassName(), entry.getNamespace(), entry.getName(), PluggableObjectType.VIRTUALDW, entry.getConfig(), classpathImportService);
        }
    }

    private void handleAddPluggableObject(String factoryClassName, String namespace, String name, PluggableObjectType type, Serializable optionalCustomConfig, ClasspathImportServiceCompileTime classpathImportService) {
        Class clazz;
        if (factoryClassName == null) {
            throw new ConfigurationException("Factory class name has not been supplied for object '" + name + "'");
        }
        if (namespace == null) {
            throw new ConfigurationException("Namespace name has not been supplied for object '" + name + "'");
        }
        if (name == null) {
            throw new ConfigurationException("Name has not been supplied for object in namespace '" + namespace + "'");
        }
        try {
            clazz = classpathImportService.getClassForNameProvider().classForName(factoryClassName);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("View factory class " + factoryClassName + " could not be loaded");
        }
        Map<String, Pair<Class, PluggableObjectEntry>> namespaceMap = this.pluggables.get(namespace);
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, Pair<Class, PluggableObjectEntry>>();
            this.pluggables.put(namespace, namespaceMap);
        }
        namespaceMap.put(name, new Pair<Class, PluggableObjectEntry>(clazz, new PluggableObjectEntry(type, optionalCustomConfig)));
    }

    private void initPatterns(List<ConfigurationCompilerPlugInPatternObject> configEntries, ClasspathImportServiceCompileTime classpathImportService) throws ConfigurationException {
        if (configEntries == null) {
            return;
        }
        for (ConfigurationCompilerPlugInPatternObject entry : configEntries) {
            PluggableObjectType typeEnum;
            if (entry.getPatternObjectType() == null) {
                throw new ConfigurationException("Pattern object type has not been supplied for object '" + entry.getName() + "'");
            }
            if (entry.getPatternObjectType() == PatternObjectType.GUARD) {
                typeEnum = PluggableObjectType.PATTERN_GUARD;
            } else if (entry.getPatternObjectType() == PatternObjectType.OBSERVER) {
                typeEnum = PluggableObjectType.PATTERN_OBSERVER;
            } else {
                throw new IllegalArgumentException("Pattern object type '" + entry.getPatternObjectType() + "' not known");
            }
            this.handleAddPluggableObject(entry.getForgeClassName(), entry.getNamespace(), entry.getName(), typeEnum, null, classpathImportService);
        }
    }
}

